package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.LinksSelf;
import com.okta.sdk.resource.model.UserFactorProvider;
import com.okta.sdk.resource.model.UserFactorStatus;
import com.okta.sdk.resource.model.UserFactorType;
import java.time.OffsetDateTime;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * User Factor variant used for WebAuthn Preregistration Factors
 */
@ApiModel(description = "User Factor variant used for WebAuthn Preregistration Factors")
@JsonPropertyOrder({ WebAuthnPreregistrationFactor.JSON_PROPERTY_CREATED,
        WebAuthnPreregistrationFactor.JSON_PROPERTY_FACTOR_TYPE, WebAuthnPreregistrationFactor.JSON_PROPERTY_ID,
        WebAuthnPreregistrationFactor.JSON_PROPERTY_LAST_UPDATED, WebAuthnPreregistrationFactor.JSON_PROPERTY_PROFILE,
        WebAuthnPreregistrationFactor.JSON_PROPERTY_PROVIDER, WebAuthnPreregistrationFactor.JSON_PROPERTY_STATUS,
        WebAuthnPreregistrationFactor.JSON_PROPERTY_VENDOR_NAME, WebAuthnPreregistrationFactor.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class WebAuthnPreregistrationFactor implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;

    public static final String JSON_PROPERTY_FACTOR_TYPE = "factorType";
    private UserFactorType factorType;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;

    public static final String JSON_PROPERTY_PROFILE = "profile";
    private Object profile;

    public static final String JSON_PROPERTY_PROVIDER = "provider";
    private UserFactorProvider provider;

    public static final String JSON_PROPERTY_STATUS = "status";
    private UserFactorStatus status;

    public static final String JSON_PROPERTY_VENDOR_NAME = "vendorName";
    private String vendorName;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private LinksSelf links;

    public WebAuthnPreregistrationFactor() {
    }

    /*
     * @JsonCreator public WebAuthnPreregistrationFactor(
     *
     * @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated,
     *
     * @JsonProperty(JSON_PROPERTY_VENDOR_NAME) String vendorName ) { this(); this.created = created; this.id = id;
     * this.lastUpdated = lastUpdated; this.vendorName = vendorName; }
     */

    /**
     * Timestamp indicating when the Factor was enrolled
     *
     * @return created
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Timestamp indicating when the Factor was enrolled")
    @JsonProperty(JSON_PROPERTY_CREATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getCreated() {
        return created;
    }

    public WebAuthnPreregistrationFactor factorType(UserFactorType factorType) {

        this.factorType = factorType;
        return this;
    }

    /**
     * Get factorType
     *
     * @return factorType
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_FACTOR_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserFactorType getFactorType() {
        return factorType;
    }

    @JsonProperty(JSON_PROPERTY_FACTOR_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setFactorType(UserFactorType factorType) {
        this.factorType = factorType;
    }

    /**
     * ID of the Factor
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "ID of the Factor")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    /**
     * Timestamp indicating when the Factor was last updated
     *
     * @return lastUpdated
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Timestamp indicating when the Factor was last updated")
    @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getLastUpdated() {
        return lastUpdated;
    }

    public WebAuthnPreregistrationFactor profile(Object profile) {

        this.profile = profile;
        return this;
    }

    /**
     * Specific attributes related to the Factor
     *
     * @return profile
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Specific attributes related to the Factor")
    @JsonProperty(JSON_PROPERTY_PROFILE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Object getProfile() {
        return profile;
    }

    @JsonProperty(JSON_PROPERTY_PROFILE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setProfile(Object profile) {
        this.profile = profile;
    }

    public WebAuthnPreregistrationFactor provider(UserFactorProvider provider) {

        this.provider = provider;
        return this;
    }

    /**
     * Get provider
     *
     * @return provider
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_PROVIDER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserFactorProvider getProvider() {
        return provider;
    }

    @JsonProperty(JSON_PROPERTY_PROVIDER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setProvider(UserFactorProvider provider) {
        this.provider = provider;
    }

    public WebAuthnPreregistrationFactor status(UserFactorStatus status) {

        this.status = status;
        return this;
    }

    /**
     * Get status
     *
     * @return status
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserFactorStatus getStatus() {
        return status;
    }

    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(UserFactorStatus status) {
        this.status = status;
    }

    /**
     * Name of the Factor vendor. This is usually the same as the provider.
     *
     * @return vendorName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "OKTA", value = "Name of the Factor vendor. This is usually the same as the provider.")
    @JsonProperty(JSON_PROPERTY_VENDOR_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getVendorName() {
        return vendorName;
    }

    public WebAuthnPreregistrationFactor links(LinksSelf links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LinksSelf getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(LinksSelf links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        WebAuthnPreregistrationFactor webAuthnPreregistrationFactor = (WebAuthnPreregistrationFactor) o;
        return Objects.equals(this.created, webAuthnPreregistrationFactor.created)
                && Objects.equals(this.factorType, webAuthnPreregistrationFactor.factorType)
                && Objects.equals(this.id, webAuthnPreregistrationFactor.id)
                && Objects.equals(this.lastUpdated, webAuthnPreregistrationFactor.lastUpdated)
                && Objects.equals(this.profile, webAuthnPreregistrationFactor.profile)
                && Objects.equals(this.provider, webAuthnPreregistrationFactor.provider)
                && Objects.equals(this.status, webAuthnPreregistrationFactor.status)
                && Objects.equals(this.vendorName, webAuthnPreregistrationFactor.vendorName)
                && Objects.equals(this.links, webAuthnPreregistrationFactor.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(created, factorType, id, lastUpdated, profile, provider, status, vendorName, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebAuthnPreregistrationFactor {\n");
        sb.append("    created: ").append(toIndentedString(created)).append("\n");
        sb.append("    factorType: ").append(toIndentedString(factorType)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    profile: ").append(toIndentedString(profile)).append("\n");
        sb.append("    provider: ").append(toIndentedString(provider)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    vendorName: ").append(toIndentedString(vendorName)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
