/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.Pair;
import com.okta.sdk.resource.model.InlineHook;
import com.okta.sdk.resource.model.InlineHookResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class InlineHookApi {
    private ApiClient apiClient;

    public InlineHookApi() {
        this(Configuration.getDefaultApiClient());
    }

    public InlineHookApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public InlineHook activateInlineHook(String inlineHookId) throws ApiException {
        return this.activateInlineHook(inlineHookId, Collections.emptyMap());
    }

    public InlineHook activateInlineHook(String inlineHookId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (inlineHookId == null) {
            throw new ApiException(400, "Missing the required parameter 'inlineHookId' when calling activateInlineHook");
        }
        String localVarPath = "/api/v1/inlineHooks/{inlineHookId}/lifecycle/activate".replaceAll("\\{inlineHookId\\}", this.apiClient.escapeString(inlineHookId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<InlineHook> localVarReturnType = new TypeReference<InlineHook>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public InlineHook createInlineHook(InlineHook inlineHook) throws ApiException {
        return this.createInlineHook(inlineHook, Collections.emptyMap());
    }

    public InlineHook createInlineHook(InlineHook inlineHook, Map<String, String> additionalHeaders) throws ApiException {
        InlineHook localVarPostBody = inlineHook;
        if (inlineHook == null) {
            throw new ApiException(400, "Missing the required parameter 'inlineHook' when calling createInlineHook");
        }
        String localVarPath = "/api/v1/inlineHooks";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<InlineHook> localVarReturnType = new TypeReference<InlineHook>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public InlineHook deactivateInlineHook(String inlineHookId) throws ApiException {
        return this.deactivateInlineHook(inlineHookId, Collections.emptyMap());
    }

    public InlineHook deactivateInlineHook(String inlineHookId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (inlineHookId == null) {
            throw new ApiException(400, "Missing the required parameter 'inlineHookId' when calling deactivateInlineHook");
        }
        String localVarPath = "/api/v1/inlineHooks/{inlineHookId}/lifecycle/deactivate".replaceAll("\\{inlineHookId\\}", this.apiClient.escapeString(inlineHookId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<InlineHook> localVarReturnType = new TypeReference<InlineHook>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteInlineHook(String inlineHookId) throws ApiException {
        this.deleteInlineHook(inlineHookId, Collections.emptyMap());
    }

    public void deleteInlineHook(String inlineHookId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (inlineHookId == null) {
            throw new ApiException(400, "Missing the required parameter 'inlineHookId' when calling deleteInlineHook");
        }
        String localVarPath = "/api/v1/inlineHooks/{inlineHookId}".replaceAll("\\{inlineHookId\\}", this.apiClient.escapeString(inlineHookId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public InlineHookResponse executeInlineHook(String inlineHookId, Object payloadData) throws ApiException {
        return this.executeInlineHook(inlineHookId, payloadData, Collections.emptyMap());
    }

    public InlineHookResponse executeInlineHook(String inlineHookId, Object payloadData, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = payloadData;
        if (inlineHookId == null) {
            throw new ApiException(400, "Missing the required parameter 'inlineHookId' when calling executeInlineHook");
        }
        if (payloadData == null) {
            throw new ApiException(400, "Missing the required parameter 'payloadData' when calling executeInlineHook");
        }
        String localVarPath = "/api/v1/inlineHooks/{inlineHookId}/execute".replaceAll("\\{inlineHookId\\}", this.apiClient.escapeString(inlineHookId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<InlineHookResponse> localVarReturnType = new TypeReference<InlineHookResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public InlineHook getInlineHook(String inlineHookId) throws ApiException {
        return this.getInlineHook(inlineHookId, Collections.emptyMap());
    }

    public InlineHook getInlineHook(String inlineHookId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (inlineHookId == null) {
            throw new ApiException(400, "Missing the required parameter 'inlineHookId' when calling getInlineHook");
        }
        String localVarPath = "/api/v1/inlineHooks/{inlineHookId}".replaceAll("\\{inlineHookId\\}", this.apiClient.escapeString(inlineHookId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<InlineHook> localVarReturnType = new TypeReference<InlineHook>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<InlineHook> listInlineHooks(String type) throws ApiException {
        return this.listInlineHooks(type, Collections.emptyMap());
    }

    public List<InlineHook> listInlineHooks(String type, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/inlineHooks";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("type", type));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<InlineHook>> localVarReturnType = new TypeReference<List<InlineHook>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public InlineHook replaceInlineHook(String inlineHookId, InlineHook inlineHook) throws ApiException {
        return this.replaceInlineHook(inlineHookId, inlineHook, Collections.emptyMap());
    }

    public InlineHook replaceInlineHook(String inlineHookId, InlineHook inlineHook, Map<String, String> additionalHeaders) throws ApiException {
        InlineHook localVarPostBody = inlineHook;
        if (inlineHookId == null) {
            throw new ApiException(400, "Missing the required parameter 'inlineHookId' when calling replaceInlineHook");
        }
        if (inlineHook == null) {
            throw new ApiException(400, "Missing the required parameter 'inlineHook' when calling replaceInlineHook");
        }
        String localVarPath = "/api/v1/inlineHooks/{inlineHookId}".replaceAll("\\{inlineHookId\\}", this.apiClient.escapeString(inlineHookId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<InlineHook> localVarReturnType = new TypeReference<InlineHook>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public InlineHook updateInlineHook(String inlineHookId, InlineHook inlineHook) throws ApiException {
        return this.updateInlineHook(inlineHookId, inlineHook, Collections.emptyMap());
    }

    public InlineHook updateInlineHook(String inlineHookId, InlineHook inlineHook, Map<String, String> additionalHeaders) throws ApiException {
        InlineHook localVarPostBody = inlineHook;
        if (inlineHookId == null) {
            throw new ApiException(400, "Missing the required parameter 'inlineHookId' when calling updateInlineHook");
        }
        if (inlineHook == null) {
            throw new ApiException(400, "Missing the required parameter 'inlineHook' when calling updateInlineHook");
        }
        String localVarPath = "/api/v1/inlineHooks/{inlineHookId}".replaceAll("\\{inlineHookId\\}", this.apiClient.escapeString(inlineHookId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<InlineHook> localVarReturnType = new TypeReference<InlineHook>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

