/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.ApiTokenNetwork;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An API Token Update Object for an Okta user. This token is NOT scoped any further and can be used for any API that the user has permissions to call.")
@JsonPropertyOrder(value={"clientName", "created", "name", "network", "userId"})
public class ApiTokenUpdate
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CLIENT_NAME = "clientName";
    private String clientName;
    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_NETWORK = "network";
    private ApiTokenNetwork network;
    public static final String JSON_PROPERTY_USER_ID = "userId";
    private String userId;

    @Nullable
    @ApiModelProperty(value="The client name associated with the API Token")
    @JsonProperty(value="clientName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClientName() {
        return this.clientName;
    }

    @Nullable
    @ApiModelProperty(value="The creation date of the API Token")
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreated() {
        return this.created;
    }

    public ApiTokenUpdate name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name associated with the API Token")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public ApiTokenUpdate network(ApiTokenNetwork network) {
        this.network = network;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="network")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApiTokenNetwork getNetwork() {
        return this.network;
    }

    @JsonProperty(value="network")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetwork(ApiTokenNetwork network) {
        this.network = network;
    }

    public ApiTokenUpdate userId(String userId) {
        this.userId = userId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The userId of the user who created the API Token")
    @JsonProperty(value="userId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUserId() {
        return this.userId;
    }

    @JsonProperty(value="userId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserId(String userId) {
        this.userId = userId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiTokenUpdate apiTokenUpdate = (ApiTokenUpdate)o;
        return Objects.equals(this.clientName, apiTokenUpdate.clientName) && Objects.equals(this.created, apiTokenUpdate.created) && Objects.equals(this.name, apiTokenUpdate.name) && Objects.equals(this.network, apiTokenUpdate.network) && Objects.equals(this.userId, apiTokenUpdate.userId);
    }

    public int hashCode() {
        return Objects.hash(this.clientName, this.created, this.name, this.network, this.userId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiTokenUpdate {\n");
        sb.append("    clientName: ").append(this.toIndentedString(this.clientName)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    network: ").append(this.toIndentedString(this.network)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

