/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;

@JsonPropertyOrder(value={"body", "subject"})
public class EmailContent
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_BODY = "body";
    private String body;
    public static final String JSON_PROPERTY_SUBJECT = "subject";
    private String subject;

    public EmailContent body(String body) {
        this.body = body;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The HTML body of the email. May contain [variable references](https://velocity.apache.org/engine/1.7/user-guide.html#references).   <x-lifecycle class=\"ea\"></x-lifecycle> Not required if Custom languages for Okta Email Templates is enabled. A `null` body is replaced with a default value from one of the following in priority order:  1. An existing default email customization, if one exists 2. Okta-provided translated content for the specified language, if one exists 3. Okta-provided translated content for the brand locale, if it's set  4. Okta-provided content in English ")
    @JsonProperty(value="body")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getBody() {
        return this.body;
    }

    @JsonProperty(value="body")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBody(String body) {
        this.body = body;
    }

    public EmailContent subject(String subject) {
        this.subject = subject;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The email subject. May contain [variable references](https://velocity.apache.org/engine/1.7/user-guide.html#references).  <x-lifecycle class=\"ea\"></x-lifecycle> Not required if Custom languages for Okta Email Templates is enabled. A `null` subject is replaced with a default value from one of the following in priority order:  1. An existing default email customization, if one exists 2. Okta-provided translated content for the specified language, if one exists 3. Okta-provided translated content for the brand locale, if it's set 4. Okta-provided content in English ")
    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSubject() {
        return this.subject;
    }

    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSubject(String subject) {
        this.subject = subject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmailContent emailContent = (EmailContent)o;
        return Objects.equals(this.body, emailContent.body) && Objects.equals(this.subject, emailContent.subject);
    }

    public int hashCode() {
        return Objects.hash(this.body, this.subject);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EmailContent {\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

