/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.StreamConfigurationAud;
import com.okta.sdk.resource.model.StreamConfigurationDelivery;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"aud", "delivery", "events_delivered", "events_requested", "events_supported", "format", "iss", "min_verification_interval", "stream_id"})
@JsonTypeName(value="getSsfStreams_200_response")
public class GetSsfStreams200Response
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_AUD = "aud";
    private StreamConfigurationAud aud;
    public static final String JSON_PROPERTY_DELIVERY = "delivery";
    private StreamConfigurationDelivery delivery;
    public static final String JSON_PROPERTY_EVENTS_DELIVERED = "events_delivered";
    private List<URI> eventsDelivered = null;
    public static final String JSON_PROPERTY_EVENTS_REQUESTED = "events_requested";
    private List<URI> eventsRequested = new ArrayList<URI>();
    public static final String JSON_PROPERTY_EVENTS_SUPPORTED = "events_supported";
    private List<URI> eventsSupported = null;
    public static final String JSON_PROPERTY_FORMAT = "format";
    private FormatEnum format;
    public static final String JSON_PROPERTY_ISS = "iss";
    private String iss;
    public static final String JSON_PROPERTY_MIN_VERIFICATION_INTERVAL = "min_verification_interval";
    private JsonNullable<Integer> minVerificationInterval = JsonNullable.undefined();
    public static final String JSON_PROPERTY_STREAM_ID = "stream_id";
    private String streamId;

    public GetSsfStreams200Response aud(StreamConfigurationAud aud) {
        this.aud = aud;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="aud")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StreamConfigurationAud getAud() {
        return this.aud;
    }

    @JsonProperty(value="aud")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAud(StreamConfigurationAud aud) {
        this.aud = aud;
    }

    public GetSsfStreams200Response delivery(StreamConfigurationDelivery delivery) {
        this.delivery = delivery;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="delivery")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StreamConfigurationDelivery getDelivery() {
        return this.delivery;
    }

    @JsonProperty(value="delivery")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDelivery(StreamConfigurationDelivery delivery) {
        this.delivery = delivery;
    }

    public GetSsfStreams200Response eventsDelivered(List<URI> eventsDelivered) {
        this.eventsDelivered = eventsDelivered;
        return this;
    }

    public GetSsfStreams200Response addeventsDeliveredItem(URI eventsDeliveredItem) {
        if (this.eventsDelivered == null) {
            this.eventsDelivered = new ArrayList<URI>();
        }
        this.eventsDelivered.add(eventsDeliveredItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[https://schemas.openid.net/secevent/caep/event-type/session-revoked, https://schemas.openid.net/secevent/caep/event-type/credential-change]", value="The events (mapped by the array of event type URIs) that the transmitter actually delivers to the SSF Stream.  A read-only parameter that is set by the transmitter. If this parameter is included in the request, the value must match the expected value from the transmitter.")
    @JsonProperty(value="events_delivered")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<URI> getEventsDelivered() {
        return this.eventsDelivered;
    }

    @JsonProperty(value="events_delivered")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEventsDelivered(List<URI> eventsDelivered) {
        this.eventsDelivered = eventsDelivered;
    }

    public GetSsfStreams200Response eventsRequested(List<URI> eventsRequested) {
        this.eventsRequested = eventsRequested;
        return this;
    }

    public GetSsfStreams200Response addeventsRequestedItem(URI eventsRequestedItem) {
        if (this.eventsRequested == null) {
            this.eventsRequested = new ArrayList<URI>();
        }
        this.eventsRequested.add(eventsRequestedItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="[https://schemas.openid.net/secevent/caep/event-type/session-revoked, https://schemas.openid.net/secevent/caep/event-type/credential-change]", required=true, value="The events (mapped by the array of event type URIs) that the receiver wants to receive")
    @JsonProperty(value="events_requested")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<URI> getEventsRequested() {
        return this.eventsRequested;
    }

    @JsonProperty(value="events_requested")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEventsRequested(List<URI> eventsRequested) {
        this.eventsRequested = eventsRequested;
    }

    public GetSsfStreams200Response eventsSupported(List<URI> eventsSupported) {
        this.eventsSupported = eventsSupported;
        return this;
    }

    public GetSsfStreams200Response addeventsSupportedItem(URI eventsSupportedItem) {
        if (this.eventsSupported == null) {
            this.eventsSupported = new ArrayList<URI>();
        }
        this.eventsSupported.add(eventsSupportedItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[https://schemas.openid.net/secevent/caep/event-type/session-revoked, https://schemas.openid.net/secevent/caep/event-type/credential-change]", value="An array of event type URIs that the transmitter supports.  A read-only parameter that is set by the transmitter. If this parameter is included in the request, the value must match the expected value from the transmitter.")
    @JsonProperty(value="events_supported")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<URI> getEventsSupported() {
        return this.eventsSupported;
    }

    @JsonProperty(value="events_supported")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEventsSupported(List<URI> eventsSupported) {
        this.eventsSupported = eventsSupported;
    }

    public GetSsfStreams200Response format(FormatEnum format) {
        this.format = format;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Subject Identifier format expected for any SET transmitted.")
    @JsonProperty(value="format")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FormatEnum getFormat() {
        return this.format;
    }

    @JsonProperty(value="format")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFormat(FormatEnum format) {
        this.format = format;
    }

    public GetSsfStreams200Response iss(String iss) {
        this.iss = iss;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://{yourOktaDomain}", value="The issuer used in Security Event Tokens (SETs). This value is set as `iss` in the claim.  A read-only parameter that is set by the transmitter. If this parameter is included in the request, the value must match the expected value from the transmitter.")
    @JsonProperty(value="iss")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIss() {
        return this.iss;
    }

    @JsonProperty(value="iss")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIss(String iss) {
        this.iss = iss;
    }

    public GetSsfStreams200Response minVerificationInterval(Integer minVerificationInterval) {
        this.minVerificationInterval = JsonNullable.of((Object)minVerificationInterval);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="60", value="The minimum amount of time, in seconds, between two verification requests.  A read-only parameter that is set by the transmitter. If this parameter is included in the request, the value must match the expected value from the transmitter.")
    @JsonIgnore
    public Integer getMinVerificationInterval() {
        return (Integer)this.minVerificationInterval.orElse(null);
    }

    @JsonProperty(value="min_verification_interval")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Integer> getMinVerificationInterval_JsonNullable() {
        return this.minVerificationInterval;
    }

    @JsonProperty(value="min_verification_interval")
    public void setMinVerificationInterval_JsonNullable(JsonNullable<Integer> minVerificationInterval) {
        this.minVerificationInterval = minVerificationInterval;
    }

    public void setMinVerificationInterval(Integer minVerificationInterval) {
        this.minVerificationInterval = JsonNullable.of((Object)minVerificationInterval);
    }

    public GetSsfStreams200Response streamId(String streamId) {
        this.streamId = streamId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="esc1k235GIIztAuGK0g5", value="The ID of the SSF Stream configuration")
    @JsonProperty(value="stream_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStreamId() {
        return this.streamId;
    }

    @JsonProperty(value="stream_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStreamId(String streamId) {
        this.streamId = streamId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetSsfStreams200Response getSsfStreams200Response = (GetSsfStreams200Response)o;
        return Objects.equals(this.aud, getSsfStreams200Response.aud) && Objects.equals(this.delivery, getSsfStreams200Response.delivery) && Objects.equals(this.eventsDelivered, getSsfStreams200Response.eventsDelivered) && Objects.equals(this.eventsRequested, getSsfStreams200Response.eventsRequested) && Objects.equals(this.eventsSupported, getSsfStreams200Response.eventsSupported) && Objects.equals((Object)this.format, (Object)getSsfStreams200Response.format) && Objects.equals(this.iss, getSsfStreams200Response.iss) && GetSsfStreams200Response.equalsNullable(this.minVerificationInterval, getSsfStreams200Response.minVerificationInterval) && Objects.equals(this.streamId, getSsfStreams200Response.streamId);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.aud, this.delivery, this.eventsDelivered, this.eventsRequested, this.eventsSupported, this.format, this.iss, GetSsfStreams200Response.hashCodeNullable(this.minVerificationInterval), this.streamId});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetSsfStreams200Response {\n");
        sb.append("    aud: ").append(this.toIndentedString(this.aud)).append("\n");
        sb.append("    delivery: ").append(this.toIndentedString(this.delivery)).append("\n");
        sb.append("    eventsDelivered: ").append(this.toIndentedString(this.eventsDelivered)).append("\n");
        sb.append("    eventsRequested: ").append(this.toIndentedString(this.eventsRequested)).append("\n");
        sb.append("    eventsSupported: ").append(this.toIndentedString(this.eventsSupported)).append("\n");
        sb.append("    format: ").append(this.toIndentedString((Object)this.format)).append("\n");
        sb.append("    iss: ").append(this.toIndentedString(this.iss)).append("\n");
        sb.append("    minVerificationInterval: ").append(this.toIndentedString(this.minVerificationInterval)).append("\n");
        sb.append("    streamId: ").append(this.toIndentedString(this.streamId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum FormatEnum {
        ISS_SUB("iss_sub"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private FormatEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FormatEnum fromValue(String value) {
            for (FormatEnum b : FormatEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

