/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The `securityContext` object provides security information that is directly related to the evaluation of the event's IP reputation. IP reputation is a trustworthiness rating that evaluates how likely a sender is to be malicious and is based on the sender's IP address. As the name implies, the `securityContext` object is useful for security applications-flagging and inspecting suspicious events.")
@JsonPropertyOrder(value={"asNumber", "asOrg", "domain", "isp", "isProxy"})
public class LogSecurityContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_AS_NUMBER = "asNumber";
    private Integer asNumber;
    public static final String JSON_PROPERTY_AS_ORG = "asOrg";
    private String asOrg;
    public static final String JSON_PROPERTY_DOMAIN = "domain";
    private String domain;
    public static final String JSON_PROPERTY_ISP = "isp";
    private String isp;
    public static final String JSON_PROPERTY_IS_PROXY = "isProxy";
    private Boolean isProxy;

    @Nullable
    @ApiModelProperty(value="The [Autonomous system](https://docs.telemetry.mozilla.org/datasets/other/asn_aggregates/reference) number that's associated with the autonomous system the event request was sourced to")
    @JsonProperty(value="asNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getAsNumber() {
        return this.asNumber;
    }

    @Nullable
    @ApiModelProperty(value="The organization that is associated with the autonomous system that the event request is sourced to")
    @JsonProperty(value="asOrg")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAsOrg() {
        return this.asOrg;
    }

    @Nullable
    @ApiModelProperty(value="The domain name that's associated with the IP address of the inbound event request")
    @JsonProperty(value="domain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDomain() {
        return this.domain;
    }

    @Nullable
    @ApiModelProperty(value="The Internet service provider that's used to send the event's request")
    @JsonProperty(value="isp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIsp() {
        return this.isp;
    }

    @Nullable
    @ApiModelProperty(value="Specifies whether an event's request is from a known proxy")
    @JsonProperty(value="isProxy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsProxy() {
        return this.isProxy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogSecurityContext logSecurityContext = (LogSecurityContext)o;
        return Objects.equals(this.asNumber, logSecurityContext.asNumber) && Objects.equals(this.asOrg, logSecurityContext.asOrg) && Objects.equals(this.domain, logSecurityContext.domain) && Objects.equals(this.isp, logSecurityContext.isp) && Objects.equals(this.isProxy, logSecurityContext.isProxy);
    }

    public int hashCode() {
        return Objects.hash(this.asNumber, this.asOrg, this.domain, this.isp, this.isProxy);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogSecurityContext {\n");
        sb.append("    asNumber: ").append(this.toIndentedString(this.asNumber)).append("\n");
        sb.append("    asOrg: ").append(this.toIndentedString(this.asOrg)).append("\n");
        sb.append("    domain: ").append(this.toIndentedString(this.domain)).append("\n");
        sb.append("    isp: ").append(this.toIndentedString(this.isp)).append("\n");
        sb.append("    isProxy: ").append(this.toIndentedString(this.isProxy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

