/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Credentials for a Privileged Account")
@JsonPropertyOrder(value={"password", "username"})
public class PrivilegedAccountCredentials
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_PASSWORD = "password";
    private String password;
    public static final String JSON_PROPERTY_USERNAME = "username";
    private String username;

    public PrivilegedAccountCredentials password(String password) {
        this.password = password;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The password associated with the Privileged Account")
    @JsonProperty(value="password")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPassword(String password) {
        this.password = password;
    }

    public PrivilegedAccountCredentials username(String username) {
        this.username = username;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="testuser@example.com", required=true, value="The username associated with the Privileged Account")
    @JsonProperty(value="username")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getUsername() {
        return this.username;
    }

    @JsonProperty(value="username")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUsername(String username) {
        this.username = username;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrivilegedAccountCredentials privilegedAccountCredentials = (PrivilegedAccountCredentials)o;
        return Objects.equals(this.password, privilegedAccountCredentials.password) && Objects.equals(this.username, privilegedAccountCredentials.username);
    }

    public int hashCode() {
        return Objects.hash(this.password, this.username);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PrivilegedAccountCredentials {\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

