/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.PrivilegedAccountCredentials;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Details for a SaaS Application Account, which will be managed as a Privileged Account")
@JsonPropertyOrder(value={"appGlobalName", "appInstanceName", "credentials", "oktaApplicationId"})
public class PrivilegedAccountDetailsAppAccountSub
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_APP_GLOBAL_NAME = "appGlobalName";
    private String appGlobalName;
    public static final String JSON_PROPERTY_APP_INSTANCE_NAME = "appInstanceName";
    private String appInstanceName;
    public static final String JSON_PROPERTY_CREDENTIALS = "credentials";
    private PrivilegedAccountCredentials credentials;
    public static final String JSON_PROPERTY_OKTA_APPLICATION_ID = "oktaApplicationId";
    private String oktaApplicationId;

    public PrivilegedAccountDetailsAppAccountSub appGlobalName(String appGlobalName) {
        this.appGlobalName = appGlobalName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Salesforce", value="The name of the SaaS Application in the Okta Integration Network catalog")
    @JsonProperty(value="appGlobalName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAppGlobalName() {
        return this.appGlobalName;
    }

    @JsonProperty(value="appGlobalName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAppGlobalName(String appGlobalName) {
        this.appGlobalName = appGlobalName;
    }

    public PrivilegedAccountDetailsAppAccountSub appInstanceName(String appInstanceName) {
        this.appInstanceName = appInstanceName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Salesforce Prod", value="The instance name of the SaaS Application")
    @JsonProperty(value="appInstanceName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAppInstanceName() {
        return this.appInstanceName;
    }

    @JsonProperty(value="appInstanceName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAppInstanceName(String appInstanceName) {
        this.appInstanceName = appInstanceName;
    }

    public PrivilegedAccountDetailsAppAccountSub credentials(PrivilegedAccountCredentials credentials) {
        this.credentials = credentials;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="credentials")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PrivilegedAccountCredentials getCredentials() {
        return this.credentials;
    }

    @JsonProperty(value="credentials")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCredentials(PrivilegedAccountCredentials credentials) {
        this.credentials = credentials;
    }

    public PrivilegedAccountDetailsAppAccountSub oktaApplicationId(String oktaApplicationId) {
        this.oktaApplicationId = oktaApplicationId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="aln1aqcs055ZRoizW0g8", required=true, value="The Okta app instance ID of the SaaS Application")
    @JsonProperty(value="oktaApplicationId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getOktaApplicationId() {
        return this.oktaApplicationId;
    }

    @JsonProperty(value="oktaApplicationId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOktaApplicationId(String oktaApplicationId) {
        this.oktaApplicationId = oktaApplicationId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrivilegedAccountDetailsAppAccountSub privilegedAccountDetailsAppAccountSub = (PrivilegedAccountDetailsAppAccountSub)o;
        return Objects.equals(this.appGlobalName, privilegedAccountDetailsAppAccountSub.appGlobalName) && Objects.equals(this.appInstanceName, privilegedAccountDetailsAppAccountSub.appInstanceName) && Objects.equals(this.credentials, privilegedAccountDetailsAppAccountSub.credentials) && Objects.equals(this.oktaApplicationId, privilegedAccountDetailsAppAccountSub.oktaApplicationId);
    }

    public int hashCode() {
        return Objects.hash(this.appGlobalName, this.appInstanceName, this.credentials, this.oktaApplicationId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PrivilegedAccountDetailsAppAccountSub {\n");
        sb.append("    appGlobalName: ").append(this.toIndentedString(this.appGlobalName)).append("\n");
        sb.append("    appInstanceName: ").append(this.toIndentedString(this.appInstanceName)).append("\n");
        sb.append("    credentials: ").append(this.toIndentedString(this.credentials)).append("\n");
        sb.append("    oktaApplicationId: ").append(this.toIndentedString(this.oktaApplicationId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

