/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.AcsEndpoint;
import com.okta.sdk.resource.model.SamlAttributeStatement;
import com.okta.sdk.resource.model.SamlSpCertificate;
import com.okta.sdk.resource.model.SignOnInlineHook;
import com.okta.sdk.resource.model.SingleLogout;
import com.okta.sdk.resource.model.SloParticipate;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="SAML 2.0 sign-on attributes. > **Note:** Set either `destinationOverride` or `ssoAcsUrl` to configure any other SAML 2.0 attributes in this section.")
@JsonPropertyOrder(value={"acsEndpoints", "allowMultipleAcsEndpoints", "assertionSigned", "attributeStatements", "audience", "audienceOverride", "authnContextClassRef", "configuredAttributeStatements", "defaultRelayState", "destination", "destinationOverride", "digestAlgorithm", "honorForceAuthn", "idpIssuer", "inlineHooks", "participateSlo", "recipient", "recipientOverride", "requestCompressed", "responseSigned", "samlAssertionLifetimeSeconds", "signatureAlgorithm", "slo", "spCertificate", "spIssuer", "ssoAcsUrl", "ssoAcsUrlOverride", "subjectNameIdFormat", "subjectNameIdTemplate"})
public class SamlApplicationSettingsSignOn
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ACS_ENDPOINTS = "acsEndpoints";
    private List<AcsEndpoint> acsEndpoints = null;
    public static final String JSON_PROPERTY_ALLOW_MULTIPLE_ACS_ENDPOINTS = "allowMultipleAcsEndpoints";
    private Boolean allowMultipleAcsEndpoints;
    public static final String JSON_PROPERTY_ASSERTION_SIGNED = "assertionSigned";
    private Boolean assertionSigned;
    public static final String JSON_PROPERTY_ATTRIBUTE_STATEMENTS = "attributeStatements";
    private List<SamlAttributeStatement> attributeStatements = null;
    public static final String JSON_PROPERTY_AUDIENCE = "audience";
    private String audience;
    public static final String JSON_PROPERTY_AUDIENCE_OVERRIDE = "audienceOverride";
    private String audienceOverride;
    public static final String JSON_PROPERTY_AUTHN_CONTEXT_CLASS_REF = "authnContextClassRef";
    private String authnContextClassRef;
    public static final String JSON_PROPERTY_CONFIGURED_ATTRIBUTE_STATEMENTS = "configuredAttributeStatements";
    private List<SamlAttributeStatement> configuredAttributeStatements = null;
    public static final String JSON_PROPERTY_DEFAULT_RELAY_STATE = "defaultRelayState";
    private String defaultRelayState;
    public static final String JSON_PROPERTY_DESTINATION = "destination";
    private String destination;
    public static final String JSON_PROPERTY_DESTINATION_OVERRIDE = "destinationOverride";
    private String destinationOverride;
    public static final String JSON_PROPERTY_DIGEST_ALGORITHM = "digestAlgorithm";
    private String digestAlgorithm;
    public static final String JSON_PROPERTY_HONOR_FORCE_AUTHN = "honorForceAuthn";
    private Boolean honorForceAuthn;
    public static final String JSON_PROPERTY_IDP_ISSUER = "idpIssuer";
    private String idpIssuer;
    public static final String JSON_PROPERTY_INLINE_HOOKS = "inlineHooks";
    private List<SignOnInlineHook> inlineHooks = null;
    public static final String JSON_PROPERTY_PARTICIPATE_SLO = "participateSlo";
    private SloParticipate participateSlo;
    public static final String JSON_PROPERTY_RECIPIENT = "recipient";
    private String recipient;
    public static final String JSON_PROPERTY_RECIPIENT_OVERRIDE = "recipientOverride";
    private String recipientOverride;
    public static final String JSON_PROPERTY_REQUEST_COMPRESSED = "requestCompressed";
    private Boolean requestCompressed;
    public static final String JSON_PROPERTY_RESPONSE_SIGNED = "responseSigned";
    private Boolean responseSigned;
    public static final String JSON_PROPERTY_SAML_ASSERTION_LIFETIME_SECONDS = "samlAssertionLifetimeSeconds";
    private Integer samlAssertionLifetimeSeconds;
    public static final String JSON_PROPERTY_SIGNATURE_ALGORITHM = "signatureAlgorithm";
    private String signatureAlgorithm;
    public static final String JSON_PROPERTY_SLO = "slo";
    private SingleLogout slo;
    public static final String JSON_PROPERTY_SP_CERTIFICATE = "spCertificate";
    private SamlSpCertificate spCertificate;
    public static final String JSON_PROPERTY_SP_ISSUER = "spIssuer";
    private String spIssuer;
    public static final String JSON_PROPERTY_SSO_ACS_URL = "ssoAcsUrl";
    private String ssoAcsUrl;
    public static final String JSON_PROPERTY_SSO_ACS_URL_OVERRIDE = "ssoAcsUrlOverride";
    private String ssoAcsUrlOverride;
    public static final String JSON_PROPERTY_SUBJECT_NAME_ID_FORMAT = "subjectNameIdFormat";
    private String subjectNameIdFormat;
    public static final String JSON_PROPERTY_SUBJECT_NAME_ID_TEMPLATE = "subjectNameIdTemplate";
    private String subjectNameIdTemplate;

    public SamlApplicationSettingsSignOn acsEndpoints(List<AcsEndpoint> acsEndpoints) {
        this.acsEndpoints = acsEndpoints;
        return this;
    }

    public SamlApplicationSettingsSignOn addacsEndpointsItem(AcsEndpoint acsEndpointsItem) {
        if (this.acsEndpoints == null) {
            this.acsEndpoints = new ArrayList<AcsEndpoint>();
        }
        this.acsEndpoints.add(acsEndpointsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An array of ACS endpoints. You can configure a maximum of 100 endpoints.")
    @JsonProperty(value="acsEndpoints")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<AcsEndpoint> getAcsEndpoints() {
        return this.acsEndpoints;
    }

    @JsonProperty(value="acsEndpoints")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAcsEndpoints(List<AcsEndpoint> acsEndpoints) {
        this.acsEndpoints = acsEndpoints;
    }

    public SamlApplicationSettingsSignOn allowMultipleAcsEndpoints(Boolean allowMultipleAcsEndpoints) {
        this.allowMultipleAcsEndpoints = allowMultipleAcsEndpoints;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Determines whether the app allows you to configure multiple ACS URIs")
    @JsonProperty(value="allowMultipleAcsEndpoints")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getAllowMultipleAcsEndpoints() {
        return this.allowMultipleAcsEndpoints;
    }

    @JsonProperty(value="allowMultipleAcsEndpoints")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAllowMultipleAcsEndpoints(Boolean allowMultipleAcsEndpoints) {
        this.allowMultipleAcsEndpoints = allowMultipleAcsEndpoints;
    }

    public SamlApplicationSettingsSignOn assertionSigned(Boolean assertionSigned) {
        this.assertionSigned = assertionSigned;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Determines whether the SAML assertion is digitally signed")
    @JsonProperty(value="assertionSigned")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getAssertionSigned() {
        return this.assertionSigned;
    }

    @JsonProperty(value="assertionSigned")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAssertionSigned(Boolean assertionSigned) {
        this.assertionSigned = assertionSigned;
    }

    public SamlApplicationSettingsSignOn attributeStatements(List<SamlAttributeStatement> attributeStatements) {
        this.attributeStatements = attributeStatements;
        return this;
    }

    public SamlApplicationSettingsSignOn addattributeStatementsItem(SamlAttributeStatement attributeStatementsItem) {
        if (this.attributeStatements == null) {
            this.attributeStatements = new ArrayList<SamlAttributeStatement>();
        }
        this.attributeStatements.add(attributeStatementsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of custom attribute statements for the app's SAML assertion. See [SAML 2.0 Technical Overview](https://docs.oasis-open.org/security/saml/Post2.0/sstc-saml-tech-overview-2.0-cd-02.html).  There are two types of attribute statements: | Type | Description | | ---- | ----------- | | EXPRESSION | Generic attribute statement that can be dynamic and supports [Okta Expression Language](https://developer.okta.com/docs/reference/okta-expression-language/) | | GROUP | Group attribute statement | ")
    @JsonProperty(value="attributeStatements")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SamlAttributeStatement> getAttributeStatements() {
        return this.attributeStatements;
    }

    @JsonProperty(value="attributeStatements")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAttributeStatements(List<SamlAttributeStatement> attributeStatements) {
        this.attributeStatements = attributeStatements;
    }

    public SamlApplicationSettingsSignOn audience(String audience) {
        this.audience = audience;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The entity ID of the SP. Use the entity ID value exactly as provided by the SP.")
    @JsonProperty(value="audience")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAudience() {
        return this.audience;
    }

    @JsonProperty(value="audience")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAudience(String audience) {
        this.audience = audience;
    }

    public SamlApplicationSettingsSignOn audienceOverride(String audienceOverride) {
        this.audienceOverride = audienceOverride;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Audience override for CASB configuration. See [CASB config guide](https://help.okta.com/en-us/Content/Topics/Apps/CASB-config-guide.htm).")
    @JsonProperty(value="audienceOverride")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAudienceOverride() {
        return this.audienceOverride;
    }

    @JsonProperty(value="audienceOverride")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAudienceOverride(String audienceOverride) {
        this.audienceOverride = audienceOverride;
    }

    public SamlApplicationSettingsSignOn authnContextClassRef(String authnContextClassRef) {
        this.authnContextClassRef = authnContextClassRef;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Identifies the SAML authentication context class for the assertion's authentication statement")
    @JsonProperty(value="authnContextClassRef")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAuthnContextClassRef() {
        return this.authnContextClassRef;
    }

    @JsonProperty(value="authnContextClassRef")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAuthnContextClassRef(String authnContextClassRef) {
        this.authnContextClassRef = authnContextClassRef;
    }

    public SamlApplicationSettingsSignOn configuredAttributeStatements(List<SamlAttributeStatement> configuredAttributeStatements) {
        this.configuredAttributeStatements = configuredAttributeStatements;
        return this;
    }

    public SamlApplicationSettingsSignOn addconfiguredAttributeStatementsItem(SamlAttributeStatement configuredAttributeStatementsItem) {
        if (this.configuredAttributeStatements == null) {
            this.configuredAttributeStatements = new ArrayList<SamlAttributeStatement>();
        }
        this.configuredAttributeStatements.add(configuredAttributeStatementsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The list of dynamic attribute statements for the SAML assertion inherited from app metadata (apps from the OIN) during app creation.  There are two types of attribute statements: `EXPRESSION` and `GROUP`. ")
    @JsonProperty(value="configuredAttributeStatements")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SamlAttributeStatement> getConfiguredAttributeStatements() {
        return this.configuredAttributeStatements;
    }

    @JsonProperty(value="configuredAttributeStatements")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConfiguredAttributeStatements(List<SamlAttributeStatement> configuredAttributeStatements) {
        this.configuredAttributeStatements = configuredAttributeStatements;
    }

    public SamlApplicationSettingsSignOn defaultRelayState(String defaultRelayState) {
        this.defaultRelayState = defaultRelayState;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifies a specific application resource in an IdP-initiated SSO scenario")
    @JsonProperty(value="defaultRelayState")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDefaultRelayState() {
        return this.defaultRelayState;
    }

    @JsonProperty(value="defaultRelayState")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDefaultRelayState(String defaultRelayState) {
        this.defaultRelayState = defaultRelayState;
    }

    public SamlApplicationSettingsSignOn destination(String destination) {
        this.destination = destination;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Identifies the location inside the SAML assertion where the SAML response should be sent")
    @JsonProperty(value="destination")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDestination() {
        return this.destination;
    }

    @JsonProperty(value="destination")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDestination(String destination) {
        this.destination = destination;
    }

    public SamlApplicationSettingsSignOn destinationOverride(String destinationOverride) {
        this.destinationOverride = destinationOverride;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Destination override for CASB configuration. See [CASB config guide](https://help.okta.com/en-us/Content/Topics/Apps/CASB-config-guide.htm).")
    @JsonProperty(value="destinationOverride")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDestinationOverride() {
        return this.destinationOverride;
    }

    @JsonProperty(value="destinationOverride")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDestinationOverride(String destinationOverride) {
        this.destinationOverride = destinationOverride;
    }

    public SamlApplicationSettingsSignOn digestAlgorithm(String digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Determines the digest algorithm used to digitally sign the SAML assertion and response")
    @JsonProperty(value="digestAlgorithm")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    @JsonProperty(value="digestAlgorithm")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDigestAlgorithm(String digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
    }

    public SamlApplicationSettingsSignOn honorForceAuthn(Boolean honorForceAuthn) {
        this.honorForceAuthn = honorForceAuthn;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Set to `true` to prompt users for their credentials when a SAML request has the `ForceAuthn` attribute set to `true`")
    @JsonProperty(value="honorForceAuthn")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getHonorForceAuthn() {
        return this.honorForceAuthn;
    }

    @JsonProperty(value="honorForceAuthn")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHonorForceAuthn(Boolean honorForceAuthn) {
        this.honorForceAuthn = honorForceAuthn;
    }

    public SamlApplicationSettingsSignOn idpIssuer(String idpIssuer) {
        this.idpIssuer = idpIssuer;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="SAML Issuer ID")
    @JsonProperty(value="idpIssuer")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getIdpIssuer() {
        return this.idpIssuer;
    }

    @JsonProperty(value="idpIssuer")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdpIssuer(String idpIssuer) {
        this.idpIssuer = idpIssuer;
    }

    public SamlApplicationSettingsSignOn inlineHooks(List<SignOnInlineHook> inlineHooks) {
        this.inlineHooks = inlineHooks;
        return this;
    }

    public SamlApplicationSettingsSignOn addinlineHooksItem(SignOnInlineHook inlineHooksItem) {
        if (this.inlineHooks == null) {
            this.inlineHooks = new ArrayList<SignOnInlineHook>();
        }
        this.inlineHooks.add(inlineHooksItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Associates the app with SAML inline hooks. See [the SAML assertion inline hook reference](https://developer.okta.com/docs/reference/saml-hook/).")
    @JsonProperty(value="inlineHooks")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SignOnInlineHook> getInlineHooks() {
        return this.inlineHooks;
    }

    @JsonProperty(value="inlineHooks")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInlineHooks(List<SignOnInlineHook> inlineHooks) {
        this.inlineHooks = inlineHooks;
    }

    public SamlApplicationSettingsSignOn participateSlo(SloParticipate participateSlo) {
        this.participateSlo = participateSlo;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="participateSlo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SloParticipate getParticipateSlo() {
        return this.participateSlo;
    }

    @JsonProperty(value="participateSlo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setParticipateSlo(SloParticipate participateSlo) {
        this.participateSlo = participateSlo;
    }

    public SamlApplicationSettingsSignOn recipient(String recipient) {
        this.recipient = recipient;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The location where the app may present the SAML assertion")
    @JsonProperty(value="recipient")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRecipient() {
        return this.recipient;
    }

    @JsonProperty(value="recipient")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    public SamlApplicationSettingsSignOn recipientOverride(String recipientOverride) {
        this.recipientOverride = recipientOverride;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Recipient override for CASB configuration. See [CASB config guide](https://help.okta.com/en-us/Content/Topics/Apps/CASB-config-guide.htm).")
    @JsonProperty(value="recipientOverride")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRecipientOverride() {
        return this.recipientOverride;
    }

    @JsonProperty(value="recipientOverride")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecipientOverride(String recipientOverride) {
        this.recipientOverride = recipientOverride;
    }

    public SamlApplicationSettingsSignOn requestCompressed(Boolean requestCompressed) {
        this.requestCompressed = requestCompressed;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Determines whether the SAML request is expected to be compressed")
    @JsonProperty(value="requestCompressed")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getRequestCompressed() {
        return this.requestCompressed;
    }

    @JsonProperty(value="requestCompressed")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRequestCompressed(Boolean requestCompressed) {
        this.requestCompressed = requestCompressed;
    }

    public SamlApplicationSettingsSignOn responseSigned(Boolean responseSigned) {
        this.responseSigned = responseSigned;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Determines whether the SAML authentication response message is digitally signed by the IdP > **Note:** Either (or both) `responseSigned` or `assertionSigned` must be `TRUE`.")
    @JsonProperty(value="responseSigned")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getResponseSigned() {
        return this.responseSigned;
    }

    @JsonProperty(value="responseSigned")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setResponseSigned(Boolean responseSigned) {
        this.responseSigned = responseSigned;
    }

    public SamlApplicationSettingsSignOn samlAssertionLifetimeSeconds(Integer samlAssertionLifetimeSeconds) {
        this.samlAssertionLifetimeSeconds = samlAssertionLifetimeSeconds;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="3600", value="Determines the SAML app session lifetimes with Okta")
    @JsonProperty(value="samlAssertionLifetimeSeconds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSamlAssertionLifetimeSeconds() {
        return this.samlAssertionLifetimeSeconds;
    }

    @JsonProperty(value="samlAssertionLifetimeSeconds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSamlAssertionLifetimeSeconds(Integer samlAssertionLifetimeSeconds) {
        this.samlAssertionLifetimeSeconds = samlAssertionLifetimeSeconds;
    }

    public SamlApplicationSettingsSignOn signatureAlgorithm(String signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Determines the signing algorithm used to digitally sign the SAML assertion and response")
    @JsonProperty(value="signatureAlgorithm")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    @JsonProperty(value="signatureAlgorithm")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSignatureAlgorithm(String signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public SamlApplicationSettingsSignOn slo(SingleLogout slo) {
        this.slo = slo;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="slo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SingleLogout getSlo() {
        return this.slo;
    }

    @JsonProperty(value="slo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSlo(SingleLogout slo) {
        this.slo = slo;
    }

    public SamlApplicationSettingsSignOn spCertificate(SamlSpCertificate spCertificate) {
        this.spCertificate = spCertificate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="spCertificate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SamlSpCertificate getSpCertificate() {
        return this.spCertificate;
    }

    @JsonProperty(value="spCertificate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSpCertificate(SamlSpCertificate spCertificate) {
        this.spCertificate = spCertificate;
    }

    public SamlApplicationSettingsSignOn spIssuer(String spIssuer) {
        this.spIssuer = spIssuer;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The issuer ID for the Service Provider. This property appears when SLO is enabled.")
    @JsonProperty(value="spIssuer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSpIssuer() {
        return this.spIssuer;
    }

    @JsonProperty(value="spIssuer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSpIssuer(String spIssuer) {
        this.spIssuer = spIssuer;
    }

    public SamlApplicationSettingsSignOn ssoAcsUrl(String ssoAcsUrl) {
        this.ssoAcsUrl = ssoAcsUrl;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Single Sign-On Assertion Consumer Service (ACS) URL")
    @JsonProperty(value="ssoAcsUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSsoAcsUrl() {
        return this.ssoAcsUrl;
    }

    @JsonProperty(value="ssoAcsUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSsoAcsUrl(String ssoAcsUrl) {
        this.ssoAcsUrl = ssoAcsUrl;
    }

    public SamlApplicationSettingsSignOn ssoAcsUrlOverride(String ssoAcsUrlOverride) {
        this.ssoAcsUrlOverride = ssoAcsUrlOverride;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Assertion Consumer Service (ACS) URL override for CASB configuration. See [CASB config guide](https://help.okta.com/en-us/Content/Topics/Apps/CASB-config-guide.htm).")
    @JsonProperty(value="ssoAcsUrlOverride")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSsoAcsUrlOverride() {
        return this.ssoAcsUrlOverride;
    }

    @JsonProperty(value="ssoAcsUrlOverride")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSsoAcsUrlOverride(String ssoAcsUrlOverride) {
        this.ssoAcsUrlOverride = ssoAcsUrlOverride;
    }

    public SamlApplicationSettingsSignOn subjectNameIdFormat(String subjectNameIdFormat) {
        this.subjectNameIdFormat = subjectNameIdFormat;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="subjectNameIdFormat")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSubjectNameIdFormat() {
        return this.subjectNameIdFormat;
    }

    @JsonProperty(value="subjectNameIdFormat")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSubjectNameIdFormat(String subjectNameIdFormat) {
        this.subjectNameIdFormat = subjectNameIdFormat;
    }

    public SamlApplicationSettingsSignOn subjectNameIdTemplate(String subjectNameIdTemplate) {
        this.subjectNameIdTemplate = subjectNameIdTemplate;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Template for app user's username when a user is assigned to the app")
    @JsonProperty(value="subjectNameIdTemplate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSubjectNameIdTemplate() {
        return this.subjectNameIdTemplate;
    }

    @JsonProperty(value="subjectNameIdTemplate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSubjectNameIdTemplate(String subjectNameIdTemplate) {
        this.subjectNameIdTemplate = subjectNameIdTemplate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SamlApplicationSettingsSignOn samlApplicationSettingsSignOn = (SamlApplicationSettingsSignOn)o;
        return Objects.equals(this.acsEndpoints, samlApplicationSettingsSignOn.acsEndpoints) && Objects.equals(this.allowMultipleAcsEndpoints, samlApplicationSettingsSignOn.allowMultipleAcsEndpoints) && Objects.equals(this.assertionSigned, samlApplicationSettingsSignOn.assertionSigned) && Objects.equals(this.attributeStatements, samlApplicationSettingsSignOn.attributeStatements) && Objects.equals(this.audience, samlApplicationSettingsSignOn.audience) && Objects.equals(this.audienceOverride, samlApplicationSettingsSignOn.audienceOverride) && Objects.equals(this.authnContextClassRef, samlApplicationSettingsSignOn.authnContextClassRef) && Objects.equals(this.configuredAttributeStatements, samlApplicationSettingsSignOn.configuredAttributeStatements) && Objects.equals(this.defaultRelayState, samlApplicationSettingsSignOn.defaultRelayState) && Objects.equals(this.destination, samlApplicationSettingsSignOn.destination) && Objects.equals(this.destinationOverride, samlApplicationSettingsSignOn.destinationOverride) && Objects.equals(this.digestAlgorithm, samlApplicationSettingsSignOn.digestAlgorithm) && Objects.equals(this.honorForceAuthn, samlApplicationSettingsSignOn.honorForceAuthn) && Objects.equals(this.idpIssuer, samlApplicationSettingsSignOn.idpIssuer) && Objects.equals(this.inlineHooks, samlApplicationSettingsSignOn.inlineHooks) && Objects.equals(this.participateSlo, samlApplicationSettingsSignOn.participateSlo) && Objects.equals(this.recipient, samlApplicationSettingsSignOn.recipient) && Objects.equals(this.recipientOverride, samlApplicationSettingsSignOn.recipientOverride) && Objects.equals(this.requestCompressed, samlApplicationSettingsSignOn.requestCompressed) && Objects.equals(this.responseSigned, samlApplicationSettingsSignOn.responseSigned) && Objects.equals(this.samlAssertionLifetimeSeconds, samlApplicationSettingsSignOn.samlAssertionLifetimeSeconds) && Objects.equals(this.signatureAlgorithm, samlApplicationSettingsSignOn.signatureAlgorithm) && Objects.equals(this.slo, samlApplicationSettingsSignOn.slo) && Objects.equals(this.spCertificate, samlApplicationSettingsSignOn.spCertificate) && Objects.equals(this.spIssuer, samlApplicationSettingsSignOn.spIssuer) && Objects.equals(this.ssoAcsUrl, samlApplicationSettingsSignOn.ssoAcsUrl) && Objects.equals(this.ssoAcsUrlOverride, samlApplicationSettingsSignOn.ssoAcsUrlOverride) && Objects.equals(this.subjectNameIdFormat, samlApplicationSettingsSignOn.subjectNameIdFormat) && Objects.equals(this.subjectNameIdTemplate, samlApplicationSettingsSignOn.subjectNameIdTemplate);
    }

    public int hashCode() {
        return Objects.hash(this.acsEndpoints, this.allowMultipleAcsEndpoints, this.assertionSigned, this.attributeStatements, this.audience, this.audienceOverride, this.authnContextClassRef, this.configuredAttributeStatements, this.defaultRelayState, this.destination, this.destinationOverride, this.digestAlgorithm, this.honorForceAuthn, this.idpIssuer, this.inlineHooks, this.participateSlo, this.recipient, this.recipientOverride, this.requestCompressed, this.responseSigned, this.samlAssertionLifetimeSeconds, this.signatureAlgorithm, this.slo, this.spCertificate, this.spIssuer, this.ssoAcsUrl, this.ssoAcsUrlOverride, this.subjectNameIdFormat, this.subjectNameIdTemplate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SamlApplicationSettingsSignOn {\n");
        sb.append("    acsEndpoints: ").append(this.toIndentedString(this.acsEndpoints)).append("\n");
        sb.append("    allowMultipleAcsEndpoints: ").append(this.toIndentedString(this.allowMultipleAcsEndpoints)).append("\n");
        sb.append("    assertionSigned: ").append(this.toIndentedString(this.assertionSigned)).append("\n");
        sb.append("    attributeStatements: ").append(this.toIndentedString(this.attributeStatements)).append("\n");
        sb.append("    audience: ").append(this.toIndentedString(this.audience)).append("\n");
        sb.append("    audienceOverride: ").append(this.toIndentedString(this.audienceOverride)).append("\n");
        sb.append("    authnContextClassRef: ").append(this.toIndentedString(this.authnContextClassRef)).append("\n");
        sb.append("    configuredAttributeStatements: ").append(this.toIndentedString(this.configuredAttributeStatements)).append("\n");
        sb.append("    defaultRelayState: ").append(this.toIndentedString(this.defaultRelayState)).append("\n");
        sb.append("    destination: ").append(this.toIndentedString(this.destination)).append("\n");
        sb.append("    destinationOverride: ").append(this.toIndentedString(this.destinationOverride)).append("\n");
        sb.append("    digestAlgorithm: ").append(this.toIndentedString(this.digestAlgorithm)).append("\n");
        sb.append("    honorForceAuthn: ").append(this.toIndentedString(this.honorForceAuthn)).append("\n");
        sb.append("    idpIssuer: ").append(this.toIndentedString(this.idpIssuer)).append("\n");
        sb.append("    inlineHooks: ").append(this.toIndentedString(this.inlineHooks)).append("\n");
        sb.append("    participateSlo: ").append(this.toIndentedString(this.participateSlo)).append("\n");
        sb.append("    recipient: ").append(this.toIndentedString(this.recipient)).append("\n");
        sb.append("    recipientOverride: ").append(this.toIndentedString(this.recipientOverride)).append("\n");
        sb.append("    requestCompressed: ").append(this.toIndentedString(this.requestCompressed)).append("\n");
        sb.append("    responseSigned: ").append(this.toIndentedString(this.responseSigned)).append("\n");
        sb.append("    samlAssertionLifetimeSeconds: ").append(this.toIndentedString(this.samlAssertionLifetimeSeconds)).append("\n");
        sb.append("    signatureAlgorithm: ").append(this.toIndentedString(this.signatureAlgorithm)).append("\n");
        sb.append("    slo: ").append(this.toIndentedString(this.slo)).append("\n");
        sb.append("    spCertificate: ").append(this.toIndentedString(this.spCertificate)).append("\n");
        sb.append("    spIssuer: ").append(this.toIndentedString(this.spIssuer)).append("\n");
        sb.append("    ssoAcsUrl: ").append(this.toIndentedString(this.ssoAcsUrl)).append("\n");
        sb.append("    ssoAcsUrlOverride: ").append(this.toIndentedString(this.ssoAcsUrlOverride)).append("\n");
        sb.append("    subjectNameIdFormat: ").append(this.toIndentedString(this.subjectNameIdFormat)).append("\n");
        sb.append("    subjectNameIdTemplate: ").append(this.toIndentedString(this.subjectNameIdTemplate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

