/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Provides information on the Okta user profile currently set to be used for the user who is being imported, based on the matching  rules and attribute mappings that were applied.")
@JsonPropertyOrder(value={"profile"})
@JsonTypeName(value="UserImportRequestData_user")
public class UserImportRequestDataUser
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_PROFILE = "profile";
    private Map<String, String> profile = null;

    public UserImportRequestDataUser profile(Map<String, String> profile) {
        this.profile = profile;
        return this;
    }

    public UserImportRequestDataUser putprofileItem(String key, String profileItem) {
        if (this.profile == null) {
            this.profile = new HashMap<String, String>();
        }
        this.profile.put(key, profileItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The `data.user.profile` contains the name-value pairs of the attributes in the user profile. If the user has been matched to an existing Okta user, a `data.user.id` object is included, containing the unique identifier of the Okta user profile.  You can change the values of the attributes by means of the `commands` object you return.")
    @JsonProperty(value="profile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getProfile() {
        return this.profile;
    }

    @JsonProperty(value="profile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProfile(Map<String, String> profile) {
        this.profile = profile;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserImportRequestDataUser userImportRequestDataUser = (UserImportRequestDataUser)o;
        return Objects.equals(this.profile, userImportRequestDataUser.profile);
    }

    public int hashCode() {
        return Objects.hash(this.profile);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserImportRequestDataUser {\n");
        sb.append("    profile: ").append(this.toIndentedString(this.profile)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

