/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.OAuthProvisioningEnabledApp;
import com.okta.sdk.resource.model.ProvisioningConnectionResponse;
import com.okta.sdk.resource.model.UpdateDefaultProvisioningConnectionForApplicationRequest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class ApplicationConnectionsApi {

    private ApiClient apiClient;

    public ApplicationConnectionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApplicationConnectionsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Activate the default Provisioning Connection Activates the default Provisioning Connection for an app
     *
     * @param appId
     *            Application ID (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void activateDefaultProvisioningConnectionForApplication(String appId) throws ApiException {
        this.activateDefaultProvisioningConnectionForApplication(appId, Collections.emptyMap());
    }

    /**
     * Activate the default Provisioning Connection Activates the default Provisioning Connection for an app
     *
     * @param appId
     *            Application ID (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void activateDefaultProvisioningConnectionForApplication(String appId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'appId' when calling activateDefaultProvisioningConnectionForApplication");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps/{appId}/connections/default/lifecycle/activate"
                .replaceAll("\\{" + "appId" + "\\}", apiClient.escapeString(appId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Deactivate the default Provisioning Connection Deactivates the default Provisioning Connection for an app
     *
     * @param appId
     *            Application ID (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deactivateDefaultProvisioningConnectionForApplication(String appId) throws ApiException {
        this.deactivateDefaultProvisioningConnectionForApplication(appId, Collections.emptyMap());
    }

    /**
     * Deactivate the default Provisioning Connection Deactivates the default Provisioning Connection for an app
     *
     * @param appId
     *            Application ID (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deactivateDefaultProvisioningConnectionForApplication(String appId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'appId' when calling deactivateDefaultProvisioningConnectionForApplication");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps/{appId}/connections/default/lifecycle/deactivate"
                .replaceAll("\\{" + "appId" + "\\}", apiClient.escapeString(appId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Retrieve the default Provisioning Connection Retrieves the default Provisioning Connection for an app
     *
     * @param appId
     *            Application ID (required)
     *
     * @return ProvisioningConnectionResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ProvisioningConnectionResponse getDefaultProvisioningConnectionForApplication(String appId)
            throws ApiException {
        return this.getDefaultProvisioningConnectionForApplication(appId, Collections.emptyMap());
    }

    /**
     * Retrieve the default Provisioning Connection Retrieves the default Provisioning Connection for an app
     *
     * @param appId
     *            Application ID (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return ProvisioningConnectionResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ProvisioningConnectionResponse getDefaultProvisioningConnectionForApplication(String appId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'appId' when calling getDefaultProvisioningConnectionForApplication");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps/{appId}/connections/default".replaceAll("\\{" + "appId" + "\\}",
                apiClient.escapeString(appId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<ProvisioningConnectionResponse> localVarReturnType = new TypeReference<ProvisioningConnectionResponse>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update the default Provisioning Connection Updates the default Provisioning Connection for an app
     *
     * @param appId
     *            Application ID (required)
     * @param updateDefaultProvisioningConnectionForApplicationRequest
     *            (required)
     * @param activate
     *            Activates the Provisioning Connection (optional)
     *
     * @return ProvisioningConnectionResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ProvisioningConnectionResponse updateDefaultProvisioningConnectionForApplication(String appId,
            UpdateDefaultProvisioningConnectionForApplicationRequest updateDefaultProvisioningConnectionForApplicationRequest,
            Boolean activate) throws ApiException {
        return this.updateDefaultProvisioningConnectionForApplication(appId,
                updateDefaultProvisioningConnectionForApplicationRequest, activate, Collections.emptyMap());
    }

    /**
     * Update the default Provisioning Connection Updates the default Provisioning Connection for an app
     *
     * @param appId
     *            Application ID (required)
     * @param updateDefaultProvisioningConnectionForApplicationRequest
     *            (required)
     * @param activate
     *            Activates the Provisioning Connection (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return ProvisioningConnectionResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ProvisioningConnectionResponse updateDefaultProvisioningConnectionForApplication(String appId,
            UpdateDefaultProvisioningConnectionForApplicationRequest updateDefaultProvisioningConnectionForApplicationRequest,
            Boolean activate, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = updateDefaultProvisioningConnectionForApplicationRequest;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'appId' when calling updateDefaultProvisioningConnectionForApplication");
        }

        // verify the required parameter 'updateDefaultProvisioningConnectionForApplicationRequest' is set
        if (updateDefaultProvisioningConnectionForApplicationRequest == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'updateDefaultProvisioningConnectionForApplicationRequest' when calling updateDefaultProvisioningConnectionForApplication");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps/{appId}/connections/default".replaceAll("\\{" + "appId" + "\\}",
                apiClient.escapeString(appId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("activate", activate));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<ProvisioningConnectionResponse> localVarReturnType = new TypeReference<ProvisioningConnectionResponse>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Verify the Provisioning Connection Verifies the OAuth 2.0-based connection as part of the OAuth 2.0 consent flow.
     * The validation of the consent flow is the last step of the provisioning setup for an OAuth 2.0-based connection.
     * Currently, this operation only supports &#x60;office365&#x60;,&#x60;google&#x60;, &#x60;zoomus&#x60;, and
     * &#x60;slack&#x60; apps.
     *
     * @param appName
     *            (required)
     * @param appId
     *            Application ID (required)
     * @param code
     *            (optional)
     * @param state
     *            (optional)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void verifyProvisioningConnectionForApplication(OAuthProvisioningEnabledApp appName, String appId,
            String code, String state) throws ApiException {
        this.verifyProvisioningConnectionForApplication(appName, appId, code, state, Collections.emptyMap());
    }

    /**
     * Verify the Provisioning Connection Verifies the OAuth 2.0-based connection as part of the OAuth 2.0 consent flow.
     * The validation of the consent flow is the last step of the provisioning setup for an OAuth 2.0-based connection.
     * Currently, this operation only supports &#x60;office365&#x60;,&#x60;google&#x60;, &#x60;zoomus&#x60;, and
     * &#x60;slack&#x60; apps.
     *
     * @param appName
     *            (required)
     * @param appId
     *            Application ID (required)
     * @param code
     *            (optional)
     * @param state
     *            (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void verifyProvisioningConnectionForApplication(OAuthProvisioningEnabledApp appName, String appId,
            String code, String state, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'appName' is set
        if (appName == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'appName' when calling verifyProvisioningConnectionForApplication");
        }

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'appId' when calling verifyProvisioningConnectionForApplication");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps/{appName}/{appId}/oauth2/callback"
                .replaceAll("\\{" + "appName" + "\\}", apiClient.escapeString(appName.toString()))
                .replaceAll("\\{" + "appId" + "\\}", apiClient.escapeString(appId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("code", code));
        localVarQueryParams.addAll(apiClient.parameterToPair("state", state));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
