/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.BehaviorRule;
import com.okta.sdk.resource.model.Error;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class BehaviorApi {

    private ApiClient apiClient;

    public BehaviorApi() {
        this(Configuration.getDefaultApiClient());
    }

    public BehaviorApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Activate a Behavior Detection Rule Activates a behavior detection rule
     *
     * @param behaviorId
     *            id of the Behavior Detection Rule (required)
     *
     * @return BehaviorRule
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public BehaviorRule activateBehaviorDetectionRule(String behaviorId) throws ApiException {
        return this.activateBehaviorDetectionRule(behaviorId, Collections.emptyMap());
    }

    /**
     * Activate a Behavior Detection Rule Activates a behavior detection rule
     *
     * @param behaviorId
     *            id of the Behavior Detection Rule (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return BehaviorRule
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public BehaviorRule activateBehaviorDetectionRule(String behaviorId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'behaviorId' is set
        if (behaviorId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'behaviorId' when calling activateBehaviorDetectionRule");
        }

        // create path and map variables
        String localVarPath = "/api/v1/behaviors/{behaviorId}/lifecycle/activate"
                .replaceAll("\\{" + "behaviorId" + "\\}", apiClient.escapeString(behaviorId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<BehaviorRule> localVarReturnType = new TypeReference<BehaviorRule>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create a Behavior Detection Rule Creates a new behavior detection rule
     *
     * @param rule
     *            (required)
     *
     * @return BehaviorRule
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public BehaviorRule createBehaviorDetectionRule(BehaviorRule rule) throws ApiException {
        return this.createBehaviorDetectionRule(rule, Collections.emptyMap());
    }

    /**
     * Create a Behavior Detection Rule Creates a new behavior detection rule
     *
     * @param rule
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return BehaviorRule
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public BehaviorRule createBehaviorDetectionRule(BehaviorRule rule, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = rule;

        // verify the required parameter 'rule' is set
        if (rule == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'rule' when calling createBehaviorDetectionRule");
        }

        // create path and map variables
        String localVarPath = "/api/v1/behaviors";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<BehaviorRule> localVarReturnType = new TypeReference<BehaviorRule>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Deactivate a Behavior Detection Rule Deactivates a behavior detection rule
     *
     * @param behaviorId
     *            id of the Behavior Detection Rule (required)
     *
     * @return BehaviorRule
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public BehaviorRule deactivateBehaviorDetectionRule(String behaviorId) throws ApiException {
        return this.deactivateBehaviorDetectionRule(behaviorId, Collections.emptyMap());
    }

    /**
     * Deactivate a Behavior Detection Rule Deactivates a behavior detection rule
     *
     * @param behaviorId
     *            id of the Behavior Detection Rule (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return BehaviorRule
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public BehaviorRule deactivateBehaviorDetectionRule(String behaviorId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'behaviorId' is set
        if (behaviorId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'behaviorId' when calling deactivateBehaviorDetectionRule");
        }

        // create path and map variables
        String localVarPath = "/api/v1/behaviors/{behaviorId}/lifecycle/deactivate"
                .replaceAll("\\{" + "behaviorId" + "\\}", apiClient.escapeString(behaviorId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<BehaviorRule> localVarReturnType = new TypeReference<BehaviorRule>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete a Behavior Detection Rule Deletes a Behavior Detection Rule by &#x60;behaviorId&#x60;
     *
     * @param behaviorId
     *            id of the Behavior Detection Rule (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteBehaviorDetectionRule(String behaviorId) throws ApiException {
        this.deleteBehaviorDetectionRule(behaviorId, Collections.emptyMap());
    }

    /**
     * Delete a Behavior Detection Rule Deletes a Behavior Detection Rule by &#x60;behaviorId&#x60;
     *
     * @param behaviorId
     *            id of the Behavior Detection Rule (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteBehaviorDetectionRule(String behaviorId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'behaviorId' is set
        if (behaviorId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'behaviorId' when calling deleteBehaviorDetectionRule");
        }

        // create path and map variables
        String localVarPath = "/api/v1/behaviors/{behaviorId}".replaceAll("\\{" + "behaviorId" + "\\}",
                apiClient.escapeString(behaviorId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Retrieve a Behavior Detection Rule Retrieves a Behavior Detection Rule by &#x60;behaviorId&#x60;
     *
     * @param behaviorId
     *            id of the Behavior Detection Rule (required)
     *
     * @return BehaviorRule
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public BehaviorRule getBehaviorDetectionRule(String behaviorId) throws ApiException {
        return this.getBehaviorDetectionRule(behaviorId, Collections.emptyMap());
    }

    /**
     * Retrieve a Behavior Detection Rule Retrieves a Behavior Detection Rule by &#x60;behaviorId&#x60;
     *
     * @param behaviorId
     *            id of the Behavior Detection Rule (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return BehaviorRule
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public BehaviorRule getBehaviorDetectionRule(String behaviorId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'behaviorId' is set
        if (behaviorId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'behaviorId' when calling getBehaviorDetectionRule");
        }

        // create path and map variables
        String localVarPath = "/api/v1/behaviors/{behaviorId}".replaceAll("\\{" + "behaviorId" + "\\}",
                apiClient.escapeString(behaviorId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<BehaviorRule> localVarReturnType = new TypeReference<BehaviorRule>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Behavior Detection Rules Lists all behavior detection rules with pagination support
     *
     * @return List&lt;BehaviorRule&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<BehaviorRule> listBehaviorDetectionRules() throws ApiException {
        return this.listBehaviorDetectionRules(Collections.emptyMap());
    }

    /**
     * List all Behavior Detection Rules Lists all behavior detection rules with pagination support
     *
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;BehaviorRule&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<BehaviorRule> listBehaviorDetectionRules(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/behaviors";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<BehaviorRule>> localVarReturnType = new TypeReference<List<BehaviorRule>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Replace a Behavior Detection Rule Replaces a Behavior Detection Rule by &#x60;behaviorId&#x60;
     *
     * @param behaviorId
     *            id of the Behavior Detection Rule (required)
     * @param rule
     *            (required)
     *
     * @return BehaviorRule
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public BehaviorRule replaceBehaviorDetectionRule(String behaviorId, BehaviorRule rule) throws ApiException {
        return this.replaceBehaviorDetectionRule(behaviorId, rule, Collections.emptyMap());
    }

    /**
     * Replace a Behavior Detection Rule Replaces a Behavior Detection Rule by &#x60;behaviorId&#x60;
     *
     * @param behaviorId
     *            id of the Behavior Detection Rule (required)
     * @param rule
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return BehaviorRule
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public BehaviorRule replaceBehaviorDetectionRule(String behaviorId, BehaviorRule rule,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = rule;

        // verify the required parameter 'behaviorId' is set
        if (behaviorId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'behaviorId' when calling replaceBehaviorDetectionRule");
        }

        // verify the required parameter 'rule' is set
        if (rule == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'rule' when calling replaceBehaviorDetectionRule");
        }

        // create path and map variables
        String localVarPath = "/api/v1/behaviors/{behaviorId}".replaceAll("\\{" + "behaviorId" + "\\}",
                apiClient.escapeString(behaviorId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<BehaviorRule> localVarReturnType = new TypeReference<BehaviorRule>() {
        };
        return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
