/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.IdentityProvider;
import com.okta.sdk.resource.model.IdentityProviderType;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class IdentityProviderApi {

    private ApiClient apiClient;

    public IdentityProviderApi() {
        this(Configuration.getDefaultApiClient());
    }

    public IdentityProviderApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Activate an Identity Provider Activates an inactive IdP
     *
     * @param idpId
     *            &#x60;id&#x60; of IdP (required)
     *
     * @return IdentityProvider
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public IdentityProvider activateIdentityProvider(String idpId) throws ApiException {
        return this.activateIdentityProvider(idpId, Collections.emptyMap());
    }

    /**
     * Activate an Identity Provider Activates an inactive IdP
     *
     * @param idpId
     *            &#x60;id&#x60; of IdP (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return IdentityProvider
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public IdentityProvider activateIdentityProvider(String idpId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'idpId' is set
        if (idpId == null) {
            throw new ApiException(400, "Missing the required parameter 'idpId' when calling activateIdentityProvider");
        }

        // create path and map variables
        String localVarPath = "/api/v1/idps/{idpId}/lifecycle/activate".replaceAll("\\{" + "idpId" + "\\}",
                apiClient.escapeString(idpId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<IdentityProvider> localVarReturnType = new TypeReference<IdentityProvider>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create an Identity Provider Creates a new Identity Provider integration. #### SAML 2.0 Identity Provider You must
     * first add the IdP&#39;s signature certificate to the IdP key store before you can add a SAML 2.0 IdP with a
     * &#x60;kid&#x60; credential reference. Don&#39;t use &#x60;fromURI&#x60; to automatically redirect a user to a
     * particular app after successfully authenticating with a third-party IdP. Instead, use SAML deep links. Using
     * &#x60;fromURI&#x60; isn&#39;t tested or supported. For more information about using deep links when signing users
     * in using an SP-initiated flow, see [Understanding SP-Initiated Login
     * flow](https://developer.okta.com/docs/concepts/saml/#understanding-sp-initiated-login-flow). Use SAML deep links
     * to automatically redirect the user to an app after successfully authenticating with a third-party IdP. To use
     * deep links, assemble these three parts into a URL: * SP ACS URL&lt;br&gt; For example:
     * &#x60;https://${yourOktaDomain}/sso/saml2/:idpId&#x60; * The app to which the user is automatically redirected
     * after successfully authenticating with the IdP &lt;br&gt; For example:
     * &#x60;/app/:app-location/:appId/sso/saml&#x60; * Optionally, if the app is an outbound SAML app, you can specify
     * the &#x60;relayState&#x60; passed to it.&lt;br&gt; For example: &#x60;?RelayState&#x3D;:anyUrlEncodedValue&#x60;
     * The deep link for the above three parts is:&lt;br&gt;
     * &#x60;https://${yourOktaDomain}/sso/saml2/:idpId/app/:app-location/:appId/sso/saml?RelayState&#x3D;:anyUrlEncodedValue&#x60;
     * #### Smart Card X509 Identity Provider You must first add the IdP&#39;s server certificate to the IdP key store
     * before you can add a Smart Card &#x60;X509&#x60; IdP with a &#x60;kid&#x60; credential reference. You need to
     * upload the whole trust chain as a single key using the [Key Store
     * API](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/IdentityProviderKeys/#tag/IdentityProviderKeys/operation/createIdentityProviderKey).
     * Depending on the information stored in the smart card, select the proper
     * [template](https://developer.okta.com/docs/reference/okta-expression-language/#idp-user-profile)
     * &#x60;idpuser.subjectAltNameEmail&#x60; or &#x60;idpuser.subjectAltNameUpn&#x60;.
     *
     * @param identityProvider
     *            IdP settings (required)
     *
     * @return IdentityProvider
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public IdentityProvider createIdentityProvider(IdentityProvider identityProvider) throws ApiException {
        return this.createIdentityProvider(identityProvider, Collections.emptyMap());
    }

    /**
     * Create an Identity Provider Creates a new Identity Provider integration. #### SAML 2.0 Identity Provider You must
     * first add the IdP&#39;s signature certificate to the IdP key store before you can add a SAML 2.0 IdP with a
     * &#x60;kid&#x60; credential reference. Don&#39;t use &#x60;fromURI&#x60; to automatically redirect a user to a
     * particular app after successfully authenticating with a third-party IdP. Instead, use SAML deep links. Using
     * &#x60;fromURI&#x60; isn&#39;t tested or supported. For more information about using deep links when signing users
     * in using an SP-initiated flow, see [Understanding SP-Initiated Login
     * flow](https://developer.okta.com/docs/concepts/saml/#understanding-sp-initiated-login-flow). Use SAML deep links
     * to automatically redirect the user to an app after successfully authenticating with a third-party IdP. To use
     * deep links, assemble these three parts into a URL: * SP ACS URL&lt;br&gt; For example:
     * &#x60;https://${yourOktaDomain}/sso/saml2/:idpId&#x60; * The app to which the user is automatically redirected
     * after successfully authenticating with the IdP &lt;br&gt; For example:
     * &#x60;/app/:app-location/:appId/sso/saml&#x60; * Optionally, if the app is an outbound SAML app, you can specify
     * the &#x60;relayState&#x60; passed to it.&lt;br&gt; For example: &#x60;?RelayState&#x3D;:anyUrlEncodedValue&#x60;
     * The deep link for the above three parts is:&lt;br&gt;
     * &#x60;https://${yourOktaDomain}/sso/saml2/:idpId/app/:app-location/:appId/sso/saml?RelayState&#x3D;:anyUrlEncodedValue&#x60;
     * #### Smart Card X509 Identity Provider You must first add the IdP&#39;s server certificate to the IdP key store
     * before you can add a Smart Card &#x60;X509&#x60; IdP with a &#x60;kid&#x60; credential reference. You need to
     * upload the whole trust chain as a single key using the [Key Store
     * API](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/IdentityProviderKeys/#tag/IdentityProviderKeys/operation/createIdentityProviderKey).
     * Depending on the information stored in the smart card, select the proper
     * [template](https://developer.okta.com/docs/reference/okta-expression-language/#idp-user-profile)
     * &#x60;idpuser.subjectAltNameEmail&#x60; or &#x60;idpuser.subjectAltNameUpn&#x60;.
     *
     * @param identityProvider
     *            IdP settings (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return IdentityProvider
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public IdentityProvider createIdentityProvider(IdentityProvider identityProvider,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = identityProvider;

        // verify the required parameter 'identityProvider' is set
        if (identityProvider == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'identityProvider' when calling createIdentityProvider");
        }

        // create path and map variables
        String localVarPath = "/api/v1/idps";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<IdentityProvider> localVarReturnType = new TypeReference<IdentityProvider>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Deactivate an Identity Provider Deactivates an active IdP
     *
     * @param idpId
     *            &#x60;id&#x60; of IdP (required)
     *
     * @return IdentityProvider
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public IdentityProvider deactivateIdentityProvider(String idpId) throws ApiException {
        return this.deactivateIdentityProvider(idpId, Collections.emptyMap());
    }

    /**
     * Deactivate an Identity Provider Deactivates an active IdP
     *
     * @param idpId
     *            &#x60;id&#x60; of IdP (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return IdentityProvider
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public IdentityProvider deactivateIdentityProvider(String idpId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'idpId' is set
        if (idpId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'idpId' when calling deactivateIdentityProvider");
        }

        // create path and map variables
        String localVarPath = "/api/v1/idps/{idpId}/lifecycle/deactivate".replaceAll("\\{" + "idpId" + "\\}",
                apiClient.escapeString(idpId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<IdentityProvider> localVarReturnType = new TypeReference<IdentityProvider>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete an Identity Provider Deletes an identity provider integration by &#x60;idpId&#x60; * All existing IdP
     * users are unlinked with the highest order profile source taking precedence for each IdP user. * Unlinked users
     * keep their existing authentication provider such as &#x60;FEDERATION&#x60; or &#x60;SOCIAL&#x60;.
     *
     * @param idpId
     *            &#x60;id&#x60; of IdP (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteIdentityProvider(String idpId) throws ApiException {
        this.deleteIdentityProvider(idpId, Collections.emptyMap());
    }

    /**
     * Delete an Identity Provider Deletes an identity provider integration by &#x60;idpId&#x60; * All existing IdP
     * users are unlinked with the highest order profile source taking precedence for each IdP user. * Unlinked users
     * keep their existing authentication provider such as &#x60;FEDERATION&#x60; or &#x60;SOCIAL&#x60;.
     *
     * @param idpId
     *            &#x60;id&#x60; of IdP (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteIdentityProvider(String idpId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'idpId' is set
        if (idpId == null) {
            throw new ApiException(400, "Missing the required parameter 'idpId' when calling deleteIdentityProvider");
        }

        // create path and map variables
        String localVarPath = "/api/v1/idps/{idpId}".replaceAll("\\{" + "idpId" + "\\}",
                apiClient.escapeString(idpId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Retrieve an Identity Provider Retrieves an identity provider integration by &#x60;idpId&#x60;
     *
     * @param idpId
     *            &#x60;id&#x60; of IdP (required)
     *
     * @return IdentityProvider
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public IdentityProvider getIdentityProvider(String idpId) throws ApiException {
        return this.getIdentityProvider(idpId, Collections.emptyMap());
    }

    /**
     * Retrieve an Identity Provider Retrieves an identity provider integration by &#x60;idpId&#x60;
     *
     * @param idpId
     *            &#x60;id&#x60; of IdP (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return IdentityProvider
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public IdentityProvider getIdentityProvider(String idpId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'idpId' is set
        if (idpId == null) {
            throw new ApiException(400, "Missing the required parameter 'idpId' when calling getIdentityProvider");
        }

        // create path and map variables
        String localVarPath = "/api/v1/idps/{idpId}".replaceAll("\\{" + "idpId" + "\\}",
                apiClient.escapeString(idpId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<IdentityProvider> localVarReturnType = new TypeReference<IdentityProvider>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Identity Providers Lists all identity provider integrations with pagination. A subset of IdPs can be
     * returned that match a supported filter expression or query.
     *
     * @param q
     *            Searches the &#x60;name&#x60; property of IdPs for matching value (optional)
     * @param after
     *            The cursor to use for pagination. It is an opaque string that specifies your current location in the
     *            list and is obtained from the &#x60;Link&#x60; response header. See
     *            [Pagination](https://developer.okta.com/docs/api/#pagination). (optional)
     * @param limit
     *            A limit on the number of objects to return (optional, default to 20)
     * @param type
     *            Filters IdPs by &#x60;type&#x60; (optional)
     *
     * @return List&lt;IdentityProvider&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<IdentityProvider> listIdentityProviders(String q, String after, Integer limit,
            IdentityProviderType type) throws ApiException {
        return this.listIdentityProviders(q, after, limit, type, Collections.emptyMap());
    }

    /**
     * List all Identity Providers Lists all identity provider integrations with pagination. A subset of IdPs can be
     * returned that match a supported filter expression or query.
     *
     * @param q
     *            Searches the &#x60;name&#x60; property of IdPs for matching value (optional)
     * @param after
     *            The cursor to use for pagination. It is an opaque string that specifies your current location in the
     *            list and is obtained from the &#x60;Link&#x60; response header. See
     *            [Pagination](https://developer.okta.com/docs/api/#pagination). (optional)
     * @param limit
     *            A limit on the number of objects to return (optional, default to 20)
     * @param type
     *            Filters IdPs by &#x60;type&#x60; (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;IdentityProvider&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<IdentityProvider> listIdentityProviders(String q, String after, Integer limit,
            IdentityProviderType type, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/idps";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("q", q));
        localVarQueryParams.addAll(apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(apiClient.parameterToPair("type", type));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<IdentityProvider>> localVarReturnType = new TypeReference<List<IdentityProvider>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Replace an Identity Provider Replaces an identity provider integration by &#x60;idpId&#x60;
     *
     * @param idpId
     *            &#x60;id&#x60; of IdP (required)
     * @param identityProvider
     *            Updated configuration for the IdP (required)
     *
     * @return IdentityProvider
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public IdentityProvider replaceIdentityProvider(String idpId, IdentityProvider identityProvider)
            throws ApiException {
        return this.replaceIdentityProvider(idpId, identityProvider, Collections.emptyMap());
    }

    /**
     * Replace an Identity Provider Replaces an identity provider integration by &#x60;idpId&#x60;
     *
     * @param idpId
     *            &#x60;id&#x60; of IdP (required)
     * @param identityProvider
     *            Updated configuration for the IdP (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return IdentityProvider
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public IdentityProvider replaceIdentityProvider(String idpId, IdentityProvider identityProvider,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = identityProvider;

        // verify the required parameter 'idpId' is set
        if (idpId == null) {
            throw new ApiException(400, "Missing the required parameter 'idpId' when calling replaceIdentityProvider");
        }

        // verify the required parameter 'identityProvider' is set
        if (identityProvider == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'identityProvider' when calling replaceIdentityProvider");
        }

        // create path and map variables
        String localVarPath = "/api/v1/idps/{idpId}".replaceAll("\\{" + "idpId" + "\\}",
                apiClient.escapeString(idpId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<IdentityProvider> localVarReturnType = new TypeReference<IdentityProvider>() {
        };
        return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
