/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.OrgContactTypeObj;
import com.okta.sdk.resource.model.OrgContactUser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class OrgSettingContactApi {

    private ApiClient apiClient;

    public OrgSettingContactApi() {
        this(Configuration.getDefaultApiClient());
    }

    public OrgSettingContactApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Retrieve the Contact Type User Retrieves the ID and the User resource associated with the specified Contact Type
     *
     * @param contactType
     *            (required)
     *
     * @return OrgContactUser
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OrgContactUser getOrgContactUser(String contactType) throws ApiException {
        return this.getOrgContactUser(contactType, Collections.emptyMap());
    }

    /**
     * Retrieve the Contact Type User Retrieves the ID and the User resource associated with the specified Contact Type
     *
     * @param contactType
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return OrgContactUser
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OrgContactUser getOrgContactUser(String contactType, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'contactType' is set
        if (contactType == null) {
            throw new ApiException(400, "Missing the required parameter 'contactType' when calling getOrgContactUser");
        }

        // create path and map variables
        String localVarPath = "/api/v1/org/contacts/{contactType}".replaceAll("\\{" + "contactType" + "\\}",
                apiClient.escapeString(contactType.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<OrgContactUser> localVarReturnType = new TypeReference<OrgContactUser>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Org Contact Types Lists all Org Contact Types for your Okta org
     *
     * @return List&lt;OrgContactTypeObj&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<OrgContactTypeObj> listOrgContactTypes() throws ApiException {
        return this.listOrgContactTypes(Collections.emptyMap());
    }

    /**
     * List all Org Contact Types Lists all Org Contact Types for your Okta org
     *
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;OrgContactTypeObj&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<OrgContactTypeObj> listOrgContactTypes(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/org/contacts";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<OrgContactTypeObj>> localVarReturnType = new TypeReference<List<OrgContactTypeObj>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Replace the Contact Type User Replaces the User associated with the specified Contact Type
     *
     * @param contactType
     *            (required)
     * @param orgContactUser
     *            (required)
     *
     * @return OrgContactUser
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OrgContactUser replaceOrgContactUser(String contactType, OrgContactUser orgContactUser) throws ApiException {
        return this.replaceOrgContactUser(contactType, orgContactUser, Collections.emptyMap());
    }

    /**
     * Replace the Contact Type User Replaces the User associated with the specified Contact Type
     *
     * @param contactType
     *            (required)
     * @param orgContactUser
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return OrgContactUser
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OrgContactUser replaceOrgContactUser(String contactType, OrgContactUser orgContactUser,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = orgContactUser;

        // verify the required parameter 'contactType' is set
        if (contactType == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'contactType' when calling replaceOrgContactUser");
        }

        // verify the required parameter 'orgContactUser' is set
        if (orgContactUser == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'orgContactUser' when calling replaceOrgContactUser");
        }

        // create path and map variables
        String localVarPath = "/api/v1/org/contacts/{contactType}".replaceAll("\\{" + "contactType" + "\\}",
                apiClient.escapeString(contactType.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<OrgContactUser> localVarReturnType = new TypeReference<OrgContactUser>() {
        };
        return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
