/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.CreateRealmRequest;
import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.Realm;
import com.okta.sdk.resource.model.UpdateRealmRequest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class RealmApi {

    private ApiClient apiClient;

    public RealmApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RealmApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create a Realm Creates a new Realm
     *
     * @param body
     *            (required)
     *
     * @return Realm
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public Realm createRealm(CreateRealmRequest body) throws ApiException {
        return this.createRealm(body, Collections.emptyMap());
    }

    /**
     * Create a Realm Creates a new Realm
     *
     * @param body
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return Realm
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public Realm createRealm(CreateRealmRequest body, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = body;

        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createRealm");
        }

        // create path and map variables
        String localVarPath = "/api/v1/realms";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<Realm> localVarReturnType = new TypeReference<Realm>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete a Realm Deletes a Realm permanently. This operation can only be performed after disassociating other
     * entities like Users and Identity Providers from a Realm.
     *
     * @param realmId
     *            &#x60;id&#x60; of the Realm (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteRealm(String realmId) throws ApiException {
        this.deleteRealm(realmId, Collections.emptyMap());
    }

    /**
     * Delete a Realm Deletes a Realm permanently. This operation can only be performed after disassociating other
     * entities like Users and Identity Providers from a Realm.
     *
     * @param realmId
     *            &#x60;id&#x60; of the Realm (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteRealm(String realmId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'realmId' is set
        if (realmId == null) {
            throw new ApiException(400, "Missing the required parameter 'realmId' when calling deleteRealm");
        }

        // create path and map variables
        String localVarPath = "/api/v1/realms/{realmId}".replaceAll("\\{" + "realmId" + "\\}",
                apiClient.escapeString(realmId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Retrieve a Realm Retrieves a Realm
     *
     * @param realmId
     *            &#x60;id&#x60; of the Realm (required)
     *
     * @return Realm
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public Realm getRealm(String realmId) throws ApiException {
        return this.getRealm(realmId, Collections.emptyMap());
    }

    /**
     * Retrieve a Realm Retrieves a Realm
     *
     * @param realmId
     *            &#x60;id&#x60; of the Realm (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return Realm
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public Realm getRealm(String realmId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'realmId' is set
        if (realmId == null) {
            throw new ApiException(400, "Missing the required parameter 'realmId' when calling getRealm");
        }

        // create path and map variables
        String localVarPath = "/api/v1/realms/{realmId}".replaceAll("\\{" + "realmId" + "\\}",
                apiClient.escapeString(realmId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<Realm> localVarReturnType = new TypeReference<Realm>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Realms Lists all Realms
     *
     * @param limit
     *            Specifies the number of results returned. Defaults to 10 if &#x60;search&#x60; is provided. (optional,
     *            default to 200)
     * @param after
     *            The cursor to use for pagination. It is an opaque string that specifies your current location in the
     *            list and is obtained from the &#x60;Link&#x60; response header. See
     *            [Pagination](https://developer.okta.com/docs/api/#pagination). (optional)
     * @param search
     *            Searches for Realms with a supported filtering expression for most properties (optional)
     * @param sortBy
     *            Specifies field to sort by and can be any single property (for search queries only). (optional)
     * @param sortOrder
     *            Specifies sort order &#x60;asc&#x60; or &#x60;desc&#x60; (for search queries only). This parameter is
     *            ignored if &#x60;sortBy&#x60; isn&#39;t present. (optional, default to asc)
     *
     * @return List&lt;Realm&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<Realm> listRealms(Integer limit, String after, String search, String sortBy, String sortOrder)
            throws ApiException {
        return this.listRealms(limit, after, search, sortBy, sortOrder, Collections.emptyMap());
    }

    /**
     * List all Realms Lists all Realms
     *
     * @param limit
     *            Specifies the number of results returned. Defaults to 10 if &#x60;search&#x60; is provided. (optional,
     *            default to 200)
     * @param after
     *            The cursor to use for pagination. It is an opaque string that specifies your current location in the
     *            list and is obtained from the &#x60;Link&#x60; response header. See
     *            [Pagination](https://developer.okta.com/docs/api/#pagination). (optional)
     * @param search
     *            Searches for Realms with a supported filtering expression for most properties (optional)
     * @param sortBy
     *            Specifies field to sort by and can be any single property (for search queries only). (optional)
     * @param sortOrder
     *            Specifies sort order &#x60;asc&#x60; or &#x60;desc&#x60; (for search queries only). This parameter is
     *            ignored if &#x60;sortBy&#x60; isn&#39;t present. (optional, default to asc)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;Realm&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<Realm> listRealms(Integer limit, String after, String search, String sortBy, String sortOrder,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/realms";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(apiClient.parameterToPair("search", search));
        localVarQueryParams.addAll(apiClient.parameterToPair("sortBy", sortBy));
        localVarQueryParams.addAll(apiClient.parameterToPair("sortOrder", sortOrder));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<Realm>> localVarReturnType = new TypeReference<List<Realm>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Replace the realm profile Replaces the realm profile
     *
     * @param realmId
     *            &#x60;id&#x60; of the Realm (required)
     * @param body
     *            (required)
     *
     * @return Realm
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public Realm replaceRealm(String realmId, UpdateRealmRequest body) throws ApiException {
        return this.replaceRealm(realmId, body, Collections.emptyMap());
    }

    /**
     * Replace the realm profile Replaces the realm profile
     *
     * @param realmId
     *            &#x60;id&#x60; of the Realm (required)
     * @param body
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return Realm
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public Realm replaceRealm(String realmId, UpdateRealmRequest body, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = body;

        // verify the required parameter 'realmId' is set
        if (realmId == null) {
            throw new ApiException(400, "Missing the required parameter 'realmId' when calling replaceRealm");
        }

        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling replaceRealm");
        }

        // create path and map variables
        String localVarPath = "/api/v1/realms/{realmId}".replaceAll("\\{" + "realmId" + "\\}",
                apiClient.escapeString(realmId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<Realm> localVarReturnType = new TypeReference<Realm>() {
        };
        return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
