/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.TrustedOrigin;
import com.okta.sdk.resource.model.TrustedOriginWrite;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class TrustedOriginApi {

    private ApiClient apiClient;

    public TrustedOriginApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TrustedOriginApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Activate a Trusted Origin Activates a Trusted Origin. Sets the &#x60;status&#x60; to &#x60;ACTIVE&#x60;.
     *
     * @param trustedOriginId
     *            &#x60;id&#x60; of the Trusted Origin (required)
     *
     * @return TrustedOrigin
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public TrustedOrigin activateTrustedOrigin(String trustedOriginId) throws ApiException {
        return this.activateTrustedOrigin(trustedOriginId, Collections.emptyMap());
    }

    /**
     * Activate a Trusted Origin Activates a Trusted Origin. Sets the &#x60;status&#x60; to &#x60;ACTIVE&#x60;.
     *
     * @param trustedOriginId
     *            &#x60;id&#x60; of the Trusted Origin (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return TrustedOrigin
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public TrustedOrigin activateTrustedOrigin(String trustedOriginId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'trustedOriginId' is set
        if (trustedOriginId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'trustedOriginId' when calling activateTrustedOrigin");
        }

        // create path and map variables
        String localVarPath = "/api/v1/trustedOrigins/{trustedOriginId}/lifecycle/activate"
                .replaceAll("\\{" + "trustedOriginId" + "\\}", apiClient.escapeString(trustedOriginId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<TrustedOrigin> localVarReturnType = new TypeReference<TrustedOrigin>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create a Trusted Origin Creates a trusted origin
     *
     * @param trustedOrigin
     *            (required)
     *
     * @return TrustedOrigin
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public TrustedOrigin createTrustedOrigin(TrustedOriginWrite trustedOrigin) throws ApiException {
        return this.createTrustedOrigin(trustedOrigin, Collections.emptyMap());
    }

    /**
     * Create a Trusted Origin Creates a trusted origin
     *
     * @param trustedOrigin
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return TrustedOrigin
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public TrustedOrigin createTrustedOrigin(TrustedOriginWrite trustedOrigin, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = trustedOrigin;

        // verify the required parameter 'trustedOrigin' is set
        if (trustedOrigin == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'trustedOrigin' when calling createTrustedOrigin");
        }

        // create path and map variables
        String localVarPath = "/api/v1/trustedOrigins";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<TrustedOrigin> localVarReturnType = new TypeReference<TrustedOrigin>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Deactivate a Trusted Origin Deactivates a Trusted Origin. Sets the &#x60;status&#x60; to &#x60;INACTIVE&#x60;.
     *
     * @param trustedOriginId
     *            &#x60;id&#x60; of the Trusted Origin (required)
     *
     * @return TrustedOrigin
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public TrustedOrigin deactivateTrustedOrigin(String trustedOriginId) throws ApiException {
        return this.deactivateTrustedOrigin(trustedOriginId, Collections.emptyMap());
    }

    /**
     * Deactivate a Trusted Origin Deactivates a Trusted Origin. Sets the &#x60;status&#x60; to &#x60;INACTIVE&#x60;.
     *
     * @param trustedOriginId
     *            &#x60;id&#x60; of the Trusted Origin (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return TrustedOrigin
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public TrustedOrigin deactivateTrustedOrigin(String trustedOriginId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'trustedOriginId' is set
        if (trustedOriginId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'trustedOriginId' when calling deactivateTrustedOrigin");
        }

        // create path and map variables
        String localVarPath = "/api/v1/trustedOrigins/{trustedOriginId}/lifecycle/deactivate"
                .replaceAll("\\{" + "trustedOriginId" + "\\}", apiClient.escapeString(trustedOriginId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<TrustedOrigin> localVarReturnType = new TypeReference<TrustedOrigin>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete a Trusted Origin Deletes a trusted origin
     *
     * @param trustedOriginId
     *            &#x60;id&#x60; of the Trusted Origin (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteTrustedOrigin(String trustedOriginId) throws ApiException {
        this.deleteTrustedOrigin(trustedOriginId, Collections.emptyMap());
    }

    /**
     * Delete a Trusted Origin Deletes a trusted origin
     *
     * @param trustedOriginId
     *            &#x60;id&#x60; of the Trusted Origin (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteTrustedOrigin(String trustedOriginId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'trustedOriginId' is set
        if (trustedOriginId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'trustedOriginId' when calling deleteTrustedOrigin");
        }

        // create path and map variables
        String localVarPath = "/api/v1/trustedOrigins/{trustedOriginId}".replaceAll("\\{" + "trustedOriginId" + "\\}",
                apiClient.escapeString(trustedOriginId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Retrieve a Trusted Origin Retrieves a trusted origin
     *
     * @param trustedOriginId
     *            &#x60;id&#x60; of the Trusted Origin (required)
     *
     * @return TrustedOrigin
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public TrustedOrigin getTrustedOrigin(String trustedOriginId) throws ApiException {
        return this.getTrustedOrigin(trustedOriginId, Collections.emptyMap());
    }

    /**
     * Retrieve a Trusted Origin Retrieves a trusted origin
     *
     * @param trustedOriginId
     *            &#x60;id&#x60; of the Trusted Origin (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return TrustedOrigin
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public TrustedOrigin getTrustedOrigin(String trustedOriginId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'trustedOriginId' is set
        if (trustedOriginId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'trustedOriginId' when calling getTrustedOrigin");
        }

        // create path and map variables
        String localVarPath = "/api/v1/trustedOrigins/{trustedOriginId}".replaceAll("\\{" + "trustedOriginId" + "\\}",
                apiClient.escapeString(trustedOriginId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<TrustedOrigin> localVarReturnType = new TypeReference<TrustedOrigin>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Trusted Origins Lists all trusted origins
     *
     * @param q
     *            A search string that will prefix match against the &#x60;name&#x60; and &#x60;origin&#x60; (optional)
     * @param filter
     *            [Filter](/#filter) Trusted Origins with a supported expression for a subset of properties. You can
     *            filter on the following properties: &#x60;name&#x60;, &#x60;origin&#x60;, &#x60;status&#x60;, and
     *            &#x60;type&#x60; (type of scopes). (optional)
     * @param after
     *            The after cursor provided by a prior request. (optional)
     * @param limit
     *            Specifies the number of results. (optional, default to 20)
     *
     * @return List&lt;TrustedOrigin&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<TrustedOrigin> listTrustedOrigins(String q, String filter, String after, Integer limit)
            throws ApiException {
        return this.listTrustedOrigins(q, filter, after, limit, Collections.emptyMap());
    }

    /**
     * List all Trusted Origins Lists all trusted origins
     *
     * @param q
     *            A search string that will prefix match against the &#x60;name&#x60; and &#x60;origin&#x60; (optional)
     * @param filter
     *            [Filter](/#filter) Trusted Origins with a supported expression for a subset of properties. You can
     *            filter on the following properties: &#x60;name&#x60;, &#x60;origin&#x60;, &#x60;status&#x60;, and
     *            &#x60;type&#x60; (type of scopes). (optional)
     * @param after
     *            The after cursor provided by a prior request. (optional)
     * @param limit
     *            Specifies the number of results. (optional, default to 20)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;TrustedOrigin&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<TrustedOrigin> listTrustedOrigins(String q, String filter, String after, Integer limit,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/trustedOrigins";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("q", q));
        localVarQueryParams.addAll(apiClient.parameterToPair("filter", filter));
        localVarQueryParams.addAll(apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<TrustedOrigin>> localVarReturnType = new TypeReference<List<TrustedOrigin>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Replace a Trusted Origin Replaces a trusted origin
     *
     * @param trustedOriginId
     *            &#x60;id&#x60; of the Trusted Origin (required)
     * @param trustedOrigin
     *            (required)
     *
     * @return TrustedOrigin
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public TrustedOrigin replaceTrustedOrigin(String trustedOriginId, TrustedOrigin trustedOrigin) throws ApiException {
        return this.replaceTrustedOrigin(trustedOriginId, trustedOrigin, Collections.emptyMap());
    }

    /**
     * Replace a Trusted Origin Replaces a trusted origin
     *
     * @param trustedOriginId
     *            &#x60;id&#x60; of the Trusted Origin (required)
     * @param trustedOrigin
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return TrustedOrigin
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public TrustedOrigin replaceTrustedOrigin(String trustedOriginId, TrustedOrigin trustedOrigin,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = trustedOrigin;

        // verify the required parameter 'trustedOriginId' is set
        if (trustedOriginId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'trustedOriginId' when calling replaceTrustedOrigin");
        }

        // verify the required parameter 'trustedOrigin' is set
        if (trustedOrigin == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'trustedOrigin' when calling replaceTrustedOrigin");
        }

        // create path and map variables
        String localVarPath = "/api/v1/trustedOrigins/{trustedOriginId}".replaceAll("\\{" + "trustedOriginId" + "\\}",
                apiClient.escapeString(trustedOriginId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<TrustedOrigin> localVarReturnType = new TypeReference<TrustedOrigin>() {
        };
        return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
