package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * AppResourceHrefObject
 */
@JsonPropertyOrder({ AppResourceHrefObject.JSON_PROPERTY_HREF, AppResourceHrefObject.JSON_PROPERTY_TITLE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class AppResourceHrefObject implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_HREF = "href";
    private String href;

    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;

    public AppResourceHrefObject() {
    }

    public AppResourceHrefObject href(String href) {

        this.href = href;
        return this;
    }

    /**
     * Link URI
     *
     * @return href
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "https://{yourOktaDomain}/api/v1/apps/0oabskvc6442nkvQO0h7", value = "Link URI")
    @JsonProperty(JSON_PROPERTY_HREF)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getHref() {
        return href;
    }

    @JsonProperty(JSON_PROPERTY_HREF)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setHref(String href) {
        this.href = href;
    }

    public AppResourceHrefObject title(String title) {

        this.title = title;
        return this;
    }

    /**
     * Link name
     *
     * @return title
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "My App", value = "Link name")
    @JsonProperty(JSON_PROPERTY_TITLE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getTitle() {
        return title;
    }

    @JsonProperty(JSON_PROPERTY_TITLE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AppResourceHrefObject appResourceHrefObject = (AppResourceHrefObject) o;
        return Objects.equals(this.href, appResourceHrefObject.href)
                && Objects.equals(this.title, appResourceHrefObject.title);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(href, title);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppResourceHrefObject {\n");
        sb.append("    href: ").append(toIndentedString(href)).append("\n");
        sb.append("    title: ").append(toIndentedString(title)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
