package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Specifies access settings for the app
 */
@ApiModel(description = "Specifies access settings for the app")
@JsonPropertyOrder({ ApplicationAccessibility.JSON_PROPERTY_ERROR_REDIRECT_URL,
        ApplicationAccessibility.JSON_PROPERTY_LOGIN_REDIRECT_URL,
        ApplicationAccessibility.JSON_PROPERTY_SELF_SERVICE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class ApplicationAccessibility implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ERROR_REDIRECT_URL = "errorRedirectUrl";
    private String errorRedirectUrl;

    public static final String JSON_PROPERTY_LOGIN_REDIRECT_URL = "loginRedirectUrl";
    private String loginRedirectUrl;

    public static final String JSON_PROPERTY_SELF_SERVICE = "selfService";
    private Boolean selfService;

    public ApplicationAccessibility() {
    }

    public ApplicationAccessibility errorRedirectUrl(String errorRedirectUrl) {

        this.errorRedirectUrl = errorRedirectUrl;
        return this;
    }

    /**
     * Custom error page URL for the app
     *
     * @return errorRedirectUrl
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Custom error page URL for the app")
    @JsonProperty(JSON_PROPERTY_ERROR_REDIRECT_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getErrorRedirectUrl() {
        return errorRedirectUrl;
    }

    @JsonProperty(JSON_PROPERTY_ERROR_REDIRECT_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setErrorRedirectUrl(String errorRedirectUrl) {
        this.errorRedirectUrl = errorRedirectUrl;
    }

    public ApplicationAccessibility loginRedirectUrl(String loginRedirectUrl) {

        this.loginRedirectUrl = loginRedirectUrl;
        return this;
    }

    /**
     * Custom login page URL for the app &gt; **Note:** The &#x60;loginRedirectUrl&#x60; property is deprecated in
     * Identity Engine. This property is used with the custom app login feature. Orgs that actively use this feature can
     * continue to do so. See [Okta-hosted sign-in (redirect
     * authentication)](https://developer.okta.com/docs/guides/redirect-authentication/) or [configure IdP routing
     * rules](https://help.okta.com/okta_help.htm?type&#x3D;oie&amp;id&#x3D;ext-cfg-routing-rules) to redirect users to
     * the appropriate sign-in app for orgs that don&#39;t use the custom app login feature.
     *
     * @return loginRedirectUrl
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Custom login page URL for the app > **Note:** The `loginRedirectUrl` property is deprecated in Identity Engine. This property is used with the custom app login feature. Orgs that actively use this feature can continue to do so. See [Okta-hosted sign-in (redirect authentication)](https://developer.okta.com/docs/guides/redirect-authentication/) or [configure IdP routing rules](https://help.okta.com/okta_help.htm?type=oie&id=ext-cfg-routing-rules) to redirect users to the appropriate sign-in app for orgs that don't use the custom app login feature.")
    @JsonProperty(JSON_PROPERTY_LOGIN_REDIRECT_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getLoginRedirectUrl() {
        return loginRedirectUrl;
    }

    @JsonProperty(JSON_PROPERTY_LOGIN_REDIRECT_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLoginRedirectUrl(String loginRedirectUrl) {
        this.loginRedirectUrl = loginRedirectUrl;
    }

    public ApplicationAccessibility selfService(Boolean selfService) {

        this.selfService = selfService;
        return this;
    }

    /**
     * Represents whether the app can be self-assignable by users
     *
     * @return selfService
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Represents whether the app can be self-assignable by users")
    @JsonProperty(JSON_PROPERTY_SELF_SERVICE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getSelfService() {
        return selfService;
    }

    @JsonProperty(JSON_PROPERTY_SELF_SERVICE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSelfService(Boolean selfService) {
        this.selfService = selfService;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ApplicationAccessibility applicationAccessibility = (ApplicationAccessibility) o;
        return Objects.equals(this.errorRedirectUrl, applicationAccessibility.errorRedirectUrl)
                && Objects.equals(this.loginRedirectUrl, applicationAccessibility.loginRedirectUrl)
                && Objects.equals(this.selfService, applicationAccessibility.selfService);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(errorRedirectUrl, loginRedirectUrl, selfService);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationAccessibility {\n");
        sb.append("    errorRedirectUrl: ").append(toIndentedString(errorRedirectUrl)).append("\n");
        sb.append("    loginRedirectUrl: ").append(toIndentedString(loginRedirectUrl)).append("\n");
        sb.append("    selfService: ").append(toIndentedString(selfService)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
