package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.AuthenticatorEnrollmentPolicyAuthenticatorSettings;
import com.okta.sdk.resource.model.AuthenticatorEnrollmentPolicySettingsType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * **Note:** In Identity Engine, the Multifactor (MFA) Enrollment Policy name has changed to authenticator enrollment
 * policy. The policy type of &#x60;MFA_ENROLL&#x60; remains unchanged. However, the &#x60;settings&#x60; data is
 * updated for authenticators. Policy &#x60;settings&#x60; are included only for those authenticators that are enabled.
 */
@ApiModel(description = "**Note:** In Identity Engine, the Multifactor (MFA) Enrollment Policy name has changed to authenticator enrollment policy. The policy type of `MFA_ENROLL` remains unchanged. However, the `settings` data is updated for authenticators. Policy `settings` are included only for those authenticators that are enabled.")
@JsonPropertyOrder({ AuthenticatorEnrollmentPolicySettings.JSON_PROPERTY_AUTHENTICATORS,
        AuthenticatorEnrollmentPolicySettings.JSON_PROPERTY_TYPE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class AuthenticatorEnrollmentPolicySettings implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_AUTHENTICATORS = "authenticators";
    private List<AuthenticatorEnrollmentPolicyAuthenticatorSettings> authenticators = null;

    public static final String JSON_PROPERTY_TYPE = "type";
    private AuthenticatorEnrollmentPolicySettingsType type = AuthenticatorEnrollmentPolicySettingsType.FACTORS;

    public AuthenticatorEnrollmentPolicySettings() {
    }

    public AuthenticatorEnrollmentPolicySettings authenticators(
            List<AuthenticatorEnrollmentPolicyAuthenticatorSettings> authenticators) {

        this.authenticators = authenticators;
        return this;
    }

    public AuthenticatorEnrollmentPolicySettings addauthenticatorsItem(
            AuthenticatorEnrollmentPolicyAuthenticatorSettings authenticatorsItem) {
        if (this.authenticators == null) {
            this.authenticators = new ArrayList<>();
        }
        this.authenticators.add(authenticatorsItem);
        return this;
    }

    /**
     * List of authenticator policy settings &lt;x-lifecycle class&#x3D;\&quot;oie\&quot;&gt;&lt;/x-lifecycle&gt; For
     * orgs with the Authenticator enrollment policy feature enabled, the new default authenticator enrollment policy
     * created by Okta contains the &#x60;authenticators&#x60; property in the policy settings. Existing default
     * authenticator enrollment policies from a migrated Classic Engine org remain unchanged. The policies still use the
     * &#x60;factors&#x60; property in their settings. The &#x60;authenticators&#x60; parameter allows you to configure
     * all available authenticators, including authentication and recovery. The &#x60;factors&#x60; parameter only
     * allows you to configure multifactor authentication.
     *
     * @return authenticators
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "List of authenticator policy settings  <x-lifecycle class=\"oie\"></x-lifecycle> For orgs with the Authenticator enrollment policy feature enabled, the new default authenticator enrollment policy created by Okta contains the `authenticators` property in the policy settings. Existing default authenticator enrollment policies from a migrated Classic Engine org remain unchanged. The policies still use the `factors` property in their settings. The `authenticators` parameter allows you to configure all available authenticators, including authentication and recovery. The `factors` parameter only allows you to configure multifactor authentication. ")
    @JsonProperty(JSON_PROPERTY_AUTHENTICATORS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<AuthenticatorEnrollmentPolicyAuthenticatorSettings> getAuthenticators() {
        return authenticators;
    }

    @JsonProperty(JSON_PROPERTY_AUTHENTICATORS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAuthenticators(List<AuthenticatorEnrollmentPolicyAuthenticatorSettings> authenticators) {
        this.authenticators = authenticators;
    }

    public AuthenticatorEnrollmentPolicySettings type(AuthenticatorEnrollmentPolicySettingsType type) {

        this.type = type;
        return this;
    }

    /**
     * Get type
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public AuthenticatorEnrollmentPolicySettingsType getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setType(AuthenticatorEnrollmentPolicySettingsType type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AuthenticatorEnrollmentPolicySettings authenticatorEnrollmentPolicySettings = (AuthenticatorEnrollmentPolicySettings) o;
        return Objects.equals(this.authenticators, authenticatorEnrollmentPolicySettings.authenticators)
                && Objects.equals(this.type, authenticatorEnrollmentPolicySettings.type);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(authenticators, type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthenticatorEnrollmentPolicySettings {\n");
        sb.append("    authenticators: ").append(toIndentedString(authenticators)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
