package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.AuthenticatorKeyCustomAppAllOfProviderConfigurationApns;
import com.okta.sdk.resource.model.AuthenticatorKeyCustomAppAllOfProviderConfigurationFcm;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * The configuration of the provider
 */
@ApiModel(description = "The configuration of the provider")
@JsonPropertyOrder({ AuthenticatorKeyCustomAppAllOfProviderConfiguration.JSON_PROPERTY_APNS,
        AuthenticatorKeyCustomAppAllOfProviderConfiguration.JSON_PROPERTY_FCM })
@JsonTypeName("AuthenticatorKeyCustomApp_allOf_provider_configuration")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class AuthenticatorKeyCustomAppAllOfProviderConfiguration implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_APNS = "apns";
    private AuthenticatorKeyCustomAppAllOfProviderConfigurationApns apns;

    public static final String JSON_PROPERTY_FCM = "fcm";
    private AuthenticatorKeyCustomAppAllOfProviderConfigurationFcm fcm;

    public AuthenticatorKeyCustomAppAllOfProviderConfiguration() {
    }

    public AuthenticatorKeyCustomAppAllOfProviderConfiguration apns(
            AuthenticatorKeyCustomAppAllOfProviderConfigurationApns apns) {

        this.apns = apns;
        return this;
    }

    /**
     * Get apns
     *
     * @return apns
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_APNS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public AuthenticatorKeyCustomAppAllOfProviderConfigurationApns getApns() {
        return apns;
    }

    @JsonProperty(JSON_PROPERTY_APNS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setApns(AuthenticatorKeyCustomAppAllOfProviderConfigurationApns apns) {
        this.apns = apns;
    }

    public AuthenticatorKeyCustomAppAllOfProviderConfiguration fcm(
            AuthenticatorKeyCustomAppAllOfProviderConfigurationFcm fcm) {

        this.fcm = fcm;
        return this;
    }

    /**
     * Get fcm
     *
     * @return fcm
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_FCM)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public AuthenticatorKeyCustomAppAllOfProviderConfigurationFcm getFcm() {
        return fcm;
    }

    @JsonProperty(JSON_PROPERTY_FCM)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setFcm(AuthenticatorKeyCustomAppAllOfProviderConfigurationFcm fcm) {
        this.fcm = fcm;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AuthenticatorKeyCustomAppAllOfProviderConfiguration authenticatorKeyCustomAppAllOfProviderConfiguration = (AuthenticatorKeyCustomAppAllOfProviderConfiguration) o;
        return Objects.equals(this.apns, authenticatorKeyCustomAppAllOfProviderConfiguration.apns)
                && Objects.equals(this.fcm, authenticatorKeyCustomAppAllOfProviderConfiguration.fcm);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(apns, fcm);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthenticatorKeyCustomAppAllOfProviderConfiguration {\n");
        sb.append("    apns: ").append(toIndentedString(apns)).append("\n");
        sb.append("    fcm: ").append(toIndentedString(fcm)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
