package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.AllowedForEnum;
import java.math.BigDecimal;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * AuthenticatorKeyEmailAllOfSettings
 */
@JsonPropertyOrder({ AuthenticatorKeyEmailAllOfSettings.JSON_PROPERTY_ALLOWED_FOR,
        AuthenticatorKeyEmailAllOfSettings.JSON_PROPERTY_TOKEN_LIFETIME_IN_MINUTES })
@JsonTypeName("AuthenticatorKeyEmail_allOf_settings")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class AuthenticatorKeyEmailAllOfSettings implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ALLOWED_FOR = "allowedFor";
    private AllowedForEnum allowedFor;

    public static final String JSON_PROPERTY_TOKEN_LIFETIME_IN_MINUTES = "tokenLifetimeInMinutes";
    private BigDecimal tokenLifetimeInMinutes = new BigDecimal("5");

    public AuthenticatorKeyEmailAllOfSettings() {
    }

    public AuthenticatorKeyEmailAllOfSettings allowedFor(AllowedForEnum allowedFor) {

        this.allowedFor = allowedFor;
        return this;
    }

    /**
     * Get allowedFor
     *
     * @return allowedFor
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ALLOWED_FOR)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public AllowedForEnum getAllowedFor() {
        return allowedFor;
    }

    @JsonProperty(JSON_PROPERTY_ALLOWED_FOR)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAllowedFor(AllowedForEnum allowedFor) {
        this.allowedFor = allowedFor;
    }

    public AuthenticatorKeyEmailAllOfSettings tokenLifetimeInMinutes(BigDecimal tokenLifetimeInMinutes) {

        this.tokenLifetimeInMinutes = tokenLifetimeInMinutes;
        return this;
    }

    /**
     * Specifies the lifetime of an email token. Default value is 5 minutes.
     *
     * @return tokenLifetimeInMinutes
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Specifies the lifetime of an email token. Default value is 5 minutes.")
    @JsonProperty(JSON_PROPERTY_TOKEN_LIFETIME_IN_MINUTES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public BigDecimal getTokenLifetimeInMinutes() {
        return tokenLifetimeInMinutes;
    }

    @JsonProperty(JSON_PROPERTY_TOKEN_LIFETIME_IN_MINUTES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setTokenLifetimeInMinutes(BigDecimal tokenLifetimeInMinutes) {
        this.tokenLifetimeInMinutes = tokenLifetimeInMinutes;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AuthenticatorKeyEmailAllOfSettings authenticatorKeyEmailAllOfSettings = (AuthenticatorKeyEmailAllOfSettings) o;
        return Objects.equals(this.allowedFor, authenticatorKeyEmailAllOfSettings.allowedFor) && Objects
                .equals(this.tokenLifetimeInMinutes, authenticatorKeyEmailAllOfSettings.tokenLifetimeInMinutes);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(allowedFor, tokenLifetimeInMinutes);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthenticatorKeyEmailAllOfSettings {\n");
        sb.append("    allowedFor: ").append(toIndentedString(allowedFor)).append("\n");
        sb.append("    tokenLifetimeInMinutes: ").append(toIndentedString(tokenLifetimeInMinutes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
