package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.AuthorizationServerCredentialsRotationMode;
import com.okta.sdk.resource.model.AuthorizationServerCredentialsUse;
import java.time.OffsetDateTime;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * AuthorizationServerCredentialsSigningConfig
 */
@JsonPropertyOrder({ AuthorizationServerCredentialsSigningConfig.JSON_PROPERTY_KID,
        AuthorizationServerCredentialsSigningConfig.JSON_PROPERTY_LAST_ROTATED,
        AuthorizationServerCredentialsSigningConfig.JSON_PROPERTY_NEXT_ROTATION,
        AuthorizationServerCredentialsSigningConfig.JSON_PROPERTY_ROTATION_MODE,
        AuthorizationServerCredentialsSigningConfig.JSON_PROPERTY_USE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class AuthorizationServerCredentialsSigningConfig implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_KID = "kid";
    private String kid;

    public static final String JSON_PROPERTY_LAST_ROTATED = "lastRotated";
    private OffsetDateTime lastRotated;

    public static final String JSON_PROPERTY_NEXT_ROTATION = "nextRotation";
    private OffsetDateTime nextRotation;

    public static final String JSON_PROPERTY_ROTATION_MODE = "rotationMode";
    private AuthorizationServerCredentialsRotationMode rotationMode;

    public static final String JSON_PROPERTY_USE = "use";
    private AuthorizationServerCredentialsUse use;

    public AuthorizationServerCredentialsSigningConfig() {
    }

    /*
     * @JsonCreator public AuthorizationServerCredentialsSigningConfig(
     *
     * @JsonProperty(JSON_PROPERTY_KID) String kid,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_ROTATED) OffsetDateTime lastRotated,
     *
     * @JsonProperty(JSON_PROPERTY_NEXT_ROTATION) OffsetDateTime nextRotation ) { this(); this.kid = kid;
     * this.lastRotated = lastRotated; this.nextRotation = nextRotation; }
     */

    /**
     * The ID of the JSON Web Key used for signing tokens issued by the authorization server
     *
     * @return kid
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The ID of the JSON Web Key used for signing tokens issued by the authorization server")
    @JsonProperty(JSON_PROPERTY_KID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getKid() {
        return kid;
    }

    /**
     * The timestamp when the authorization server started using the &#x60;kid&#x60; for signing tokens
     *
     * @return lastRotated
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The timestamp when the authorization server started using the `kid` for signing tokens")
    @JsonProperty(JSON_PROPERTY_LAST_ROTATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getLastRotated() {
        return lastRotated;
    }

    /**
     * The timestamp when the authorization server changes the Key for signing tokens. This is only returned when
     * &#x60;rotationMode&#x60; is set to &#x60;AUTO&#x60;.
     *
     * @return nextRotation
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The timestamp when the authorization server changes the Key for signing tokens. This is only returned when `rotationMode` is set to `AUTO`.")
    @JsonProperty(JSON_PROPERTY_NEXT_ROTATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getNextRotation() {
        return nextRotation;
    }

    public AuthorizationServerCredentialsSigningConfig rotationMode(
            AuthorizationServerCredentialsRotationMode rotationMode) {

        this.rotationMode = rotationMode;
        return this;
    }

    /**
     * Get rotationMode
     *
     * @return rotationMode
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ROTATION_MODE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public AuthorizationServerCredentialsRotationMode getRotationMode() {
        return rotationMode;
    }

    @JsonProperty(JSON_PROPERTY_ROTATION_MODE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRotationMode(AuthorizationServerCredentialsRotationMode rotationMode) {
        this.rotationMode = rotationMode;
    }

    public AuthorizationServerCredentialsSigningConfig use(AuthorizationServerCredentialsUse use) {

        this.use = use;
        return this;
    }

    /**
     * Get use
     *
     * @return use
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_USE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public AuthorizationServerCredentialsUse getUse() {
        return use;
    }

    @JsonProperty(JSON_PROPERTY_USE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUse(AuthorizationServerCredentialsUse use) {
        this.use = use;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AuthorizationServerCredentialsSigningConfig authorizationServerCredentialsSigningConfig = (AuthorizationServerCredentialsSigningConfig) o;
        return Objects.equals(this.kid, authorizationServerCredentialsSigningConfig.kid)
                && Objects.equals(this.lastRotated, authorizationServerCredentialsSigningConfig.lastRotated)
                && Objects.equals(this.nextRotation, authorizationServerCredentialsSigningConfig.nextRotation)
                && Objects.equals(this.rotationMode, authorizationServerCredentialsSigningConfig.rotationMode)
                && Objects.equals(this.use, authorizationServerCredentialsSigningConfig.use);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(kid, lastRotated, nextRotation, rotationMode, use);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthorizationServerCredentialsSigningConfig {\n");
        sb.append("    kid: ").append(toIndentedString(kid)).append("\n");
        sb.append("    lastRotated: ").append(toIndentedString(lastRotated)).append("\n");
        sb.append("    nextRotation: ").append(toIndentedString(nextRotation)).append("\n");
        sb.append("    rotationMode: ").append(toIndentedString(rotationMode)).append("\n");
        sb.append("    use: ").append(toIndentedString(use)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
