package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.AuthorizationServerPolicyAllOfLinks;
import com.okta.sdk.resource.model.AuthorizationServerPolicyConditions;
import java.time.OffsetDateTime;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * AuthorizationServerPolicy
 */
@JsonPropertyOrder({ AuthorizationServerPolicy.JSON_PROPERTY_ID, AuthorizationServerPolicy.JSON_PROPERTY_TYPE,
        AuthorizationServerPolicy.JSON_PROPERTY_NAME, AuthorizationServerPolicy.JSON_PROPERTY_CONDITIONS,
        AuthorizationServerPolicy.JSON_PROPERTY_DESCRIPTION, AuthorizationServerPolicy.JSON_PROPERTY_PRIORITY,
        AuthorizationServerPolicy.JSON_PROPERTY_STATUS, AuthorizationServerPolicy.JSON_PROPERTY_SYSTEM,
        AuthorizationServerPolicy.JSON_PROPERTY_CREATED, AuthorizationServerPolicy.JSON_PROPERTY_LAST_UPDATED,
        AuthorizationServerPolicy.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class AuthorizationServerPolicy implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    /**
     * Indicates that the Policy is an authorization server Policy
     */
    public enum TypeEnum {
        OAUTH_AUTHORIZATION_POLICY(String.valueOf("OAUTH_AUTHORIZATION_POLICY")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public static final String JSON_PROPERTY_CONDITIONS = "conditions";
    private AuthorizationServerPolicyConditions conditions;

    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;

    public static final String JSON_PROPERTY_PRIORITY = "priority";
    private Integer priority;

    /**
     * Specifies whether requests have access to this Policy
     */
    public enum StatusEnum {
        ACTIVE(String.valueOf("ACTIVE")),

        INACTIVE(String.valueOf("INACTIVE")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;

    public static final String JSON_PROPERTY_SYSTEM = "system";
    private Boolean system;

    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;

    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private AuthorizationServerPolicyAllOfLinks links;

    public AuthorizationServerPolicy() {
    }

    /*
     * @JsonCreator public AuthorizationServerPolicy(
     *
     * @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated ) { this(); this.created = created;
     * this.lastUpdated = lastUpdated; }
     */

    public AuthorizationServerPolicy id(String id) {

        this.id = id;
        return this;
    }

    /**
     * ID of the Policy
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "ID of the Policy")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public AuthorizationServerPolicy type(TypeEnum type) {

        this.type = type;
        return this;
    }

    /**
     * Indicates that the Policy is an authorization server Policy
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates that the Policy is an authorization server Policy")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public TypeEnum getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public AuthorizationServerPolicy name(String name) {

        this.name = name;
        return this;
    }

    /**
     * Name of the Policy
     *
     * @return name
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Name of the Policy")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public AuthorizationServerPolicy conditions(AuthorizationServerPolicyConditions conditions) {

        this.conditions = conditions;
        return this;
    }

    /**
     * Get conditions
     *
     * @return conditions
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CONDITIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public AuthorizationServerPolicyConditions getConditions() {
        return conditions;
    }

    @JsonProperty(JSON_PROPERTY_CONDITIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setConditions(AuthorizationServerPolicyConditions conditions) {
        this.conditions = conditions;
    }

    public AuthorizationServerPolicy description(String description) {

        this.description = description;
        return this;
    }

    /**
     * Description of the Policy
     *
     * @return description
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Description of the Policy")
    @JsonProperty(JSON_PROPERTY_DESCRIPTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getDescription() {
        return description;
    }

    @JsonProperty(JSON_PROPERTY_DESCRIPTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public AuthorizationServerPolicy priority(Integer priority) {

        this.priority = priority;
        return this;
    }

    /**
     * Specifies the order in which this Policy is evaluated in relation to the other Policies in a custom authorization
     * server
     *
     * @return priority
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Specifies the order in which this Policy is evaluated in relation to the other Policies in a custom authorization server")
    @JsonProperty(JSON_PROPERTY_PRIORITY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Integer getPriority() {
        return priority;
    }

    @JsonProperty(JSON_PROPERTY_PRIORITY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public AuthorizationServerPolicy status(StatusEnum status) {

        this.status = status;
        return this;
    }

    /**
     * Specifies whether requests have access to this Policy
     *
     * @return status
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Specifies whether requests have access to this Policy")
    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public StatusEnum getStatus() {
        return status;
    }

    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public AuthorizationServerPolicy system(Boolean system) {

        this.system = system;
        return this;
    }

    /**
     * Specifies whether Okta created this Policy
     *
     * @return system
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Specifies whether Okta created this Policy")
    @JsonProperty(JSON_PROPERTY_SYSTEM)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getSystem() {
        return system;
    }

    @JsonProperty(JSON_PROPERTY_SYSTEM)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSystem(Boolean system) {
        this.system = system;
    }

    /**
     * Timestamp when the Policy was created
     *
     * @return created
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Timestamp when the Policy was created")
    @JsonProperty(JSON_PROPERTY_CREATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getCreated() {
        return created;
    }

    /**
     * Timestamp when the Policy was last updated
     *
     * @return lastUpdated
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Timestamp when the Policy was last updated")
    @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getLastUpdated() {
        return lastUpdated;
    }

    public AuthorizationServerPolicy links(AuthorizationServerPolicyAllOfLinks links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public AuthorizationServerPolicyAllOfLinks getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(AuthorizationServerPolicyAllOfLinks links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AuthorizationServerPolicy authorizationServerPolicy = (AuthorizationServerPolicy) o;
        return Objects.equals(this.id, authorizationServerPolicy.id)
                && Objects.equals(this.type, authorizationServerPolicy.type)
                && Objects.equals(this.name, authorizationServerPolicy.name)
                && Objects.equals(this.conditions, authorizationServerPolicy.conditions)
                && Objects.equals(this.description, authorizationServerPolicy.description)
                && Objects.equals(this.priority, authorizationServerPolicy.priority)
                && Objects.equals(this.status, authorizationServerPolicy.status)
                && Objects.equals(this.system, authorizationServerPolicy.system)
                && Objects.equals(this.created, authorizationServerPolicy.created)
                && Objects.equals(this.lastUpdated, authorizationServerPolicy.lastUpdated)
                && Objects.equals(this.links, authorizationServerPolicy.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, type, name, conditions, description, priority, status, system, created, lastUpdated,
                links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthorizationServerPolicy {\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    conditions: ").append(toIndentedString(conditions)).append("\n");
        sb.append("    description: ").append(toIndentedString(description)).append("\n");
        sb.append("    priority: ").append(toIndentedString(priority)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    system: ").append(toIndentedString(system)).append("\n");
        sb.append("    created: ").append(toIndentedString(created)).append("\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
