package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * The org setting that automatically assigns the Okta Admin Console when an admin role is assigned
 */
@ApiModel(description = "The org setting that automatically assigns the Okta Admin Console when an admin role is assigned")
@JsonPropertyOrder({ AutoAssignAdminAppSetting.JSON_PROPERTY_AUTO_ASSIGN_ADMIN_APP_SETTING })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class AutoAssignAdminAppSetting implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_AUTO_ASSIGN_ADMIN_APP_SETTING = "autoAssignAdminAppSetting";
    private Boolean autoAssignAdminAppSetting;

    public AutoAssignAdminAppSetting() {
    }

    public AutoAssignAdminAppSetting autoAssignAdminAppSetting(Boolean autoAssignAdminAppSetting) {

        this.autoAssignAdminAppSetting = autoAssignAdminAppSetting;
        return this;
    }

    /**
     * Automatically assigns the Okta Admin Console to the user when an admin role is assigned
     *
     * @return autoAssignAdminAppSetting
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Automatically assigns the Okta Admin Console to the user when an admin role is assigned")
    @JsonProperty(JSON_PROPERTY_AUTO_ASSIGN_ADMIN_APP_SETTING)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getAutoAssignAdminAppSetting() {
        return autoAssignAdminAppSetting;
    }

    @JsonProperty(JSON_PROPERTY_AUTO_ASSIGN_ADMIN_APP_SETTING)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAutoAssignAdminAppSetting(Boolean autoAssignAdminAppSetting) {
        this.autoAssignAdminAppSetting = autoAssignAdminAppSetting;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AutoAssignAdminAppSetting autoAssignAdminAppSetting = (AutoAssignAdminAppSetting) o;
        return Objects.equals(this.autoAssignAdminAppSetting, autoAssignAdminAppSetting.autoAssignAdminAppSetting);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(autoAssignAdminAppSetting);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AutoAssignAdminAppSetting {\n");
        sb.append("    autoAssignAdminAppSetting: ").append(toIndentedString(autoAssignAdminAppSetting)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
