package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.BaseContextSession;
import com.okta.sdk.resource.model.BaseContextUser;
import com.okta.sdk.resource.model.InlineHookRequestObject;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * This object contains a number of sub-objects, each of which provide some type of contextual information.
 */
@ApiModel(description = "This object contains a number of sub-objects, each of which provide some type of contextual information.")
@JsonPropertyOrder({ BaseContext.JSON_PROPERTY_REQUEST, BaseContext.JSON_PROPERTY_SESSION,
        BaseContext.JSON_PROPERTY_USER })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class BaseContext implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_REQUEST = "request";
    private InlineHookRequestObject request;

    public static final String JSON_PROPERTY_SESSION = "session";
    private BaseContextSession session;

    public static final String JSON_PROPERTY_USER = "user";
    private BaseContextUser user;

    public BaseContext() {
    }

    public BaseContext request(InlineHookRequestObject request) {

        this.request = request;
        return this;
    }

    /**
     * Get request
     *
     * @return request
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_REQUEST)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public InlineHookRequestObject getRequest() {
        return request;
    }

    @JsonProperty(JSON_PROPERTY_REQUEST)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRequest(InlineHookRequestObject request) {
        this.request = request;
    }

    public BaseContext session(BaseContextSession session) {

        this.session = session;
        return this;
    }

    /**
     * Get session
     *
     * @return session
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SESSION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public BaseContextSession getSession() {
        return session;
    }

    @JsonProperty(JSON_PROPERTY_SESSION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSession(BaseContextSession session) {
        this.session = session;
    }

    public BaseContext user(BaseContextUser user) {

        this.user = user;
        return this;
    }

    /**
     * Get user
     *
     * @return user
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_USER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public BaseContextUser getUser() {
        return user;
    }

    @JsonProperty(JSON_PROPERTY_USER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUser(BaseContextUser user) {
        this.user = user;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BaseContext baseContext = (BaseContext) o;
        return Objects.equals(this.request, baseContext.request) && Objects.equals(this.session, baseContext.session)
                && Objects.equals(this.user, baseContext.user);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(request, session, user);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BaseContext {\n");
        sb.append("    request: ").append(toIndentedString(request)).append("\n");
        sb.append("    session: ").append(toIndentedString(session)).append("\n");
        sb.append("    user: ").append(toIndentedString(user)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
