package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets DetectedRiskEvents
 */
public enum DetectedRiskEvents {

    ADMIN_REPORTED_USER_RISK("ADMIN_REPORTED_USER_RISK"),

    BRUTE_FORCE_ATTACK("BRUTE_FORCE_ATTACK"),

    ENTITY_CRITICAL_ACTION_FROM_HIGH_THREAT_IP("ENTITY_CRITICAL_ACTION_FROM_HIGH_THREAT_IP"),

    OKTA_THREAT_INTELLIGENCE("OKTA_THREAT_INTELLIGENCE"),

    SECURITY_EVENTS_PROVIDER_REPORTED_RISK("SECURITY_EVENTS_PROVIDER_REPORTED_RISK"),

    SESSION_INFLUENCED_USER_RISK("SESSION_INFLUENCED_USER_RISK"),

    SUSPICIOUS_APP_ACCESS("SUSPICIOUS_APP_ACCESS"),

    USER_REPORTED_SUSPICIOUS_ACTIVITY("USER_REPORTED_SUSPICIOUS_ACTIVITY"),

    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    DetectedRiskEvents(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static DetectedRiskEvents fromValue(String value) {
        for (DetectedRiskEvents b : DetectedRiskEvents.values()) {
            if (b.value.equals(value)) {
                return b;
            }
        }
        return UNKNOWN_DEFAULT_OPEN_API;
    }

    /**
     * Convert the instance into URL query string.
     *
     * @param prefix
     *            prefix of the query string
     *
     * @return URL query string
     */
    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }

        return String.format("%s=%s", prefix, this.toString().toString());
    }
}
