package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.DeviceUser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * List of associated users for the device if the &#x60;expand&#x3D;user&#x60; query parameter is specified in the
 * request. Use &#x60;expand&#x3D;userSummary&#x60; to get only a summary of each associated user for the device.
 */
@ApiModel(description = "List of associated users for the device if the `expand=user` query parameter is specified in the request. Use `expand=userSummary` to get only a summary of each associated user for the device.")
@JsonPropertyOrder({ DeviceListAllOfEmbedded.JSON_PROPERTY_USERS })
@JsonTypeName("DeviceList_allOf__embedded")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class DeviceListAllOfEmbedded implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_USERS = "users";
    private List<DeviceUser> users = null;

    public DeviceListAllOfEmbedded() {
    }

    public DeviceListAllOfEmbedded users(List<DeviceUser> users) {

        this.users = users;
        return this;
    }

    public DeviceListAllOfEmbedded addusersItem(DeviceUser usersItem) {
        if (this.users == null) {
            this.users = new ArrayList<>();
        }
        this.users.add(usersItem);
        return this;
    }

    /**
     * Users for the device
     *
     * @return users
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Users for the device")
    @JsonProperty(JSON_PROPERTY_USERS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<DeviceUser> getUsers() {
        return users;
    }

    @JsonProperty(JSON_PROPERTY_USERS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUsers(List<DeviceUser> users) {
        this.users = users;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeviceListAllOfEmbedded deviceListAllOfEmbedded = (DeviceListAllOfEmbedded) o;
        return Objects.equals(this.users, deviceListAllOfEmbedded.users);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(users);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeviceListAllOfEmbedded {\n");
        sb.append("    users: ").append(toIndentedString(users)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
