package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.EmailDomainDNSRecordType;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * EmailDomainDNSRecord
 */
@JsonPropertyOrder({ EmailDomainDNSRecord.JSON_PROPERTY_FQDN, EmailDomainDNSRecord.JSON_PROPERTY_RECORD_TYPE,
        EmailDomainDNSRecord.JSON_PROPERTY_VERIFICATION_VALUE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class EmailDomainDNSRecord implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_FQDN = "fqdn";
    private String fqdn;

    public static final String JSON_PROPERTY_RECORD_TYPE = "recordType";
    private EmailDomainDNSRecordType recordType;

    public static final String JSON_PROPERTY_VERIFICATION_VALUE = "verificationValue";
    private String verificationValue;

    public EmailDomainDNSRecord() {
    }

    public EmailDomainDNSRecord fqdn(String fqdn) {

        this.fqdn = fqdn;
        return this;
    }

    /**
     * Get fqdn
     *
     * @return fqdn
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_FQDN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getFqdn() {
        return fqdn;
    }

    @JsonProperty(JSON_PROPERTY_FQDN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setFqdn(String fqdn) {
        this.fqdn = fqdn;
    }

    public EmailDomainDNSRecord recordType(EmailDomainDNSRecordType recordType) {

        this.recordType = recordType;
        return this;
    }

    /**
     * Get recordType
     *
     * @return recordType
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_RECORD_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public EmailDomainDNSRecordType getRecordType() {
        return recordType;
    }

    @JsonProperty(JSON_PROPERTY_RECORD_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRecordType(EmailDomainDNSRecordType recordType) {
        this.recordType = recordType;
    }

    public EmailDomainDNSRecord verificationValue(String verificationValue) {

        this.verificationValue = verificationValue;
        return this;
    }

    /**
     * Get verificationValue
     *
     * @return verificationValue
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_VERIFICATION_VALUE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getVerificationValue() {
        return verificationValue;
    }

    @JsonProperty(JSON_PROPERTY_VERIFICATION_VALUE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setVerificationValue(String verificationValue) {
        this.verificationValue = verificationValue;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        EmailDomainDNSRecord emailDomainDNSRecord = (EmailDomainDNSRecord) o;
        return Objects.equals(this.fqdn, emailDomainDNSRecord.fqdn)
                && Objects.equals(this.recordType, emailDomainDNSRecord.recordType)
                && Objects.equals(this.verificationValue, emailDomainDNSRecord.verificationValue);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(fqdn, recordType, verificationValue);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EmailDomainDNSRecord {\n");
        sb.append("    fqdn: ").append(toIndentedString(fqdn)).append("\n");
        sb.append("    recordType: ").append(toIndentedString(recordType)).append("\n");
        sb.append("    verificationValue: ").append(toIndentedString(verificationValue)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
