package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.EmailSettingsResponseLinks;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * EmailSettingsResponse
 */
@JsonPropertyOrder({ EmailSettingsResponse.JSON_PROPERTY_RECIPIENTS, EmailSettingsResponse.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class EmailSettingsResponse implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * Gets or Sets recipients
     */
    public enum RecipientsEnum {
        ALL_USERS(String.valueOf("ALL_USERS")),

        ADMINS_ONLY(String.valueOf("ADMINS_ONLY")),

        NO_USERS(String.valueOf("NO_USERS")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        RecipientsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static RecipientsEnum fromValue(String value) {
            for (RecipientsEnum b : RecipientsEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_RECIPIENTS = "recipients";
    private RecipientsEnum recipients;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private EmailSettingsResponseLinks links;

    public EmailSettingsResponse() {
    }

    public EmailSettingsResponse recipients(RecipientsEnum recipients) {

        this.recipients = recipients;
        return this;
    }

    /**
     * Get recipients
     *
     * @return recipients
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_RECIPIENTS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public RecipientsEnum getRecipients() {
        return recipients;
    }

    @JsonProperty(JSON_PROPERTY_RECIPIENTS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRecipients(RecipientsEnum recipients) {
        this.recipients = recipients;
    }

    public EmailSettingsResponse links(EmailSettingsResponseLinks links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public EmailSettingsResponseLinks getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(EmailSettingsResponseLinks links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        EmailSettingsResponse emailSettingsResponse = (EmailSettingsResponse) o;
        return Objects.equals(this.recipients, emailSettingsResponse.recipients)
                && Objects.equals(this.links, emailSettingsResponse.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(recipients, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EmailSettingsResponse {\n");
        sb.append("    recipients: ").append(toIndentedString(recipients)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
