package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.EntityRiskPolicyRuleActionsObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * The object that contains the &#x60;actions&#x60; array
 */
@ApiModel(description = "The object that contains the `actions` array")
@JsonPropertyOrder({ EntityRiskPolicyRuleAllOfActionsEntityRisk.JSON_PROPERTY_ACTIONS })
@JsonTypeName("EntityRiskPolicyRule_allOf_actions_entityRisk")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class EntityRiskPolicyRuleAllOfActionsEntityRisk implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ACTIONS = "actions";
    private List<EntityRiskPolicyRuleActionsObject> actions = null;

    public EntityRiskPolicyRuleAllOfActionsEntityRisk() {
    }

    public EntityRiskPolicyRuleAllOfActionsEntityRisk actions(List<EntityRiskPolicyRuleActionsObject> actions) {

        this.actions = actions;
        return this;
    }

    public EntityRiskPolicyRuleAllOfActionsEntityRisk addactionsItem(EntityRiskPolicyRuleActionsObject actionsItem) {
        if (this.actions == null) {
            this.actions = new ArrayList<>();
        }
        this.actions.add(actionsItem);
        return this;
    }

    /**
     * The &#x60;entityRisk&#x60; object&#39;s &#x60;actions&#x60; array can be empty or contain one of two
     * &#x60;action&#x60; object value pairs. This object determines the specific response to a risk event.
     *
     * @return actions
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The `entityRisk` object's `actions` array can be empty or contain one of two `action` object value pairs. This object determines the specific response to a risk event.")
    @JsonProperty(JSON_PROPERTY_ACTIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<EntityRiskPolicyRuleActionsObject> getActions() {
        return actions;
    }

    @JsonProperty(JSON_PROPERTY_ACTIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setActions(List<EntityRiskPolicyRuleActionsObject> actions) {
        this.actions = actions;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        EntityRiskPolicyRuleAllOfActionsEntityRisk entityRiskPolicyRuleAllOfActionsEntityRisk = (EntityRiskPolicyRuleAllOfActionsEntityRisk) o;
        return Objects.equals(this.actions, entityRiskPolicyRuleAllOfActionsEntityRisk.actions);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(actions);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EntityRiskPolicyRuleAllOfActionsEntityRisk {\n");
        sb.append("    actions: ").append(toIndentedString(actions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
