package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.FeatureStageState;
import com.okta.sdk.resource.model.FeatureStageValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Current release cycle stage of a feature If a feature&#39;s stage value is &#x60;EA&#x60;, the state is
 * &#x60;null&#x60; and not returned. If the value is &#x60;BETA&#x60;, the state is &#x60;OPEN&#x60; or
 * &#x60;CLOSED&#x60; depending on whether the &#x60;BETA&#x60; feature is manageable. &gt; **Note:** If a feature&#39;s
 * stage is &#x60;OPEN BETA&#x60;, you can update it only in Preview cells. If a feature&#39;s stage is &#x60;CLOSED
 * BETA&#x60;, you can disable it only in Preview cells.
 */
@ApiModel(description = "Current release cycle stage of a feature  If a feature's stage value is `EA`, the state is `null` and not returned. If the value is `BETA`, the state is `OPEN` or `CLOSED` depending on whether the `BETA` feature is manageable.  > **Note:** If a feature's stage is `OPEN BETA`, you can update it only in Preview cells. If a feature's stage is `CLOSED BETA`, you can disable it only in Preview cells.")
@JsonPropertyOrder({ FeatureStage.JSON_PROPERTY_STATE, FeatureStage.JSON_PROPERTY_VALUE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class FeatureStage implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_STATE = "state";
    private FeatureStageState state;

    public static final String JSON_PROPERTY_VALUE = "value";
    private FeatureStageValue value;

    public FeatureStage() {
    }

    public FeatureStage state(FeatureStageState state) {

        this.state = state;
        return this;
    }

    /**
     * Get state
     *
     * @return state
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_STATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public FeatureStageState getState() {
        return state;
    }

    @JsonProperty(JSON_PROPERTY_STATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setState(FeatureStageState state) {
        this.state = state;
    }

    public FeatureStage value(FeatureStageValue value) {

        this.value = value;
        return this;
    }

    /**
     * Get value
     *
     * @return value
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_VALUE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public FeatureStageValue getValue() {
        return value;
    }

    @JsonProperty(JSON_PROPERTY_VALUE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setValue(FeatureStageValue value) {
        this.value = value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FeatureStage featureStage = (FeatureStage) o;
        return Objects.equals(this.state, featureStage.state) && Objects.equals(this.value, featureStage.value);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(state, value);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FeatureStage {\n");
        sb.append("    state: ").append(toIndentedString(state)).append("\n");
        sb.append("    value: ").append(toIndentedString(value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
