package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.GroupSchemaAttribute;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * All Okta-defined Profile properties are defined in a Profile subschema with the resolution scope &#x60;#base&#x60;.
 * These properties can&#39;t be removed or edited, regardless of any attempt to do so.
 */
@ApiModel(description = "All Okta-defined Profile properties are defined in a Profile subschema with the resolution scope `#base`. These properties can't be removed or edited, regardless of any attempt to do so.")
@JsonPropertyOrder({ GroupSchemaBaseProperties.JSON_PROPERTY_DESCRIPTION,
        GroupSchemaBaseProperties.JSON_PROPERTY_NAME })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class GroupSchemaBaseProperties implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private GroupSchemaAttribute description;

    public static final String JSON_PROPERTY_NAME = "name";
    private GroupSchemaAttribute name;

    public GroupSchemaBaseProperties() {
    }

    public GroupSchemaBaseProperties description(GroupSchemaAttribute description) {

        this.description = description;
        return this;
    }

    /**
     * Human readable description of the Group
     *
     * @return description
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Human readable description of the Group")
    @JsonProperty(JSON_PROPERTY_DESCRIPTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public GroupSchemaAttribute getDescription() {
        return description;
    }

    @JsonProperty(JSON_PROPERTY_DESCRIPTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(GroupSchemaAttribute description) {
        this.description = description;
    }

    public GroupSchemaBaseProperties name(GroupSchemaAttribute name) {

        this.name = name;
        return this;
    }

    /**
     * Unique identifier for the Group
     *
     * @return name
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Unique identifier for the Group")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public GroupSchemaAttribute getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setName(GroupSchemaAttribute name) {
        this.name = name;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GroupSchemaBaseProperties groupSchemaBaseProperties = (GroupSchemaBaseProperties) o;
        return Objects.equals(this.description, groupSchemaBaseProperties.description)
                && Objects.equals(this.name, groupSchemaBaseProperties.name);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(description, name);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GroupSchemaBaseProperties {\n");
        sb.append("    description: ").append(toIndentedString(description)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
