package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.IdentityProviderApplicationUserLinks;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * IdentityProviderApplicationUser
 */
@JsonPropertyOrder({ IdentityProviderApplicationUser.JSON_PROPERTY_CREATED,
        IdentityProviderApplicationUser.JSON_PROPERTY_EXTERNAL_ID, IdentityProviderApplicationUser.JSON_PROPERTY_ID,
        IdentityProviderApplicationUser.JSON_PROPERTY_LAST_UPDATED,
        IdentityProviderApplicationUser.JSON_PROPERTY_PROFILE, IdentityProviderApplicationUser.JSON_PROPERTY_EMBEDDED,
        IdentityProviderApplicationUser.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class IdentityProviderApplicationUser implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;

    public static final String JSON_PROPERTY_EXTERNAL_ID = "externalId";
    private String externalId;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;

    public static final String JSON_PROPERTY_PROFILE = "profile";
    private Map<String, Object> profile = null;

    public static final String JSON_PROPERTY_EMBEDDED = "_embedded";
    private Map<String, Object> embedded = null;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private IdentityProviderApplicationUserLinks links;

    public IdentityProviderApplicationUser() {
    }

    /*
     * @JsonCreator public IdentityProviderApplicationUser(
     *
     * @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created,
     *
     * @JsonProperty(JSON_PROPERTY_EXTERNAL_ID) String externalId,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated,
     *
     * @JsonProperty(JSON_PROPERTY_EMBEDDED) Map<String, Object> embedded ) { this(); this.created = created;
     * this.externalId = externalId; this.id = id; this.lastUpdated = lastUpdated; this.embedded = embedded; }
     */

    /**
     * Timestamp when the object was created
     *
     * @return created
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "2016-01-03T18:15:47Z", value = "Timestamp when the object was created")
    @JsonProperty(JSON_PROPERTY_CREATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getCreated() {
        return created;
    }

    /**
     * Unique IdP-specific identifier for the User
     *
     * @return externalId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "saml.jackson@example.com", value = "Unique IdP-specific identifier for the User")
    @JsonProperty(JSON_PROPERTY_EXTERNAL_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getExternalId() {
        return externalId;
    }

    /**
     * Unique key of the User
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Unique key of the User")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    /**
     * Timestamp when the object was last updated
     *
     * @return lastUpdated
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "2016-01-03T18:15:47Z", value = "Timestamp when the object was last updated")
    @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getLastUpdated() {
        return lastUpdated;
    }

    public IdentityProviderApplicationUser profile(Map<String, Object> profile) {

        this.profile = profile;
        return this;
    }

    public IdentityProviderApplicationUser putprofileItem(String key, Object profileItem) {
        if (this.profile == null) {
            this.profile = new HashMap<>();
        }
        this.profile.put(key, profileItem);
        return this;
    }

    /**
     * IdP-specific profile for the User. Identity Provider User profiles are IdP-specific but may be customized by the
     * Profile Editor in the Admin Console. &gt; **Note:** Okta variable names have reserved characters that may
     * conflict with the name of an IdP assertion attribute. You can use the **External name** to define the attribute
     * name as defined in an IdP assertion such as a SAML attribute name.
     *
     * @return profile
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "{\"lastName\":\"Jackson\",\"subjectNameQualifier\":\"example.com\",\"subjectSpNameQualifier\":\"urn:federation:example\",\"authnContextClassRef\":null,\"subjectNameId\":\"saml.jackson@example.com\",\"subjectConfirmationAddress\":null,\"displayName\":\"Saml Jackson\",\"mobilePhone\":\"+1-415-555-5141\",\"email\":\"saml.jackson@example.com\",\"subjectNameFormat\":\"urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress\",\"firstName\":\"Saml\",\"subjectSpProvidedId\":null,\"subjectConfirmationMethod\":null}", value = "IdP-specific profile for the User.   Identity Provider User profiles are IdP-specific but may be customized by the Profile Editor in the Admin Console.  > **Note:** Okta variable names have reserved characters that may conflict with the name of an IdP assertion attribute. You can use the **External name** to define the attribute name as defined in an IdP assertion such as a SAML attribute name.")
    @JsonProperty(JSON_PROPERTY_PROFILE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Map<String, Object> getProfile() {
        return profile;
    }

    @JsonProperty(JSON_PROPERTY_PROFILE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setProfile(Map<String, Object> profile) {
        this.profile = profile;
    }

    /**
     * Embedded resources related to the IdP User
     *
     * @return embedded
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Embedded resources related to the IdP User")
    @JsonProperty(JSON_PROPERTY_EMBEDDED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Map<String, Object> getEmbedded() {
        return embedded;
    }

    public IdentityProviderApplicationUser links(IdentityProviderApplicationUserLinks links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public IdentityProviderApplicationUserLinks getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(IdentityProviderApplicationUserLinks links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        IdentityProviderApplicationUser identityProviderApplicationUser = (IdentityProviderApplicationUser) o;
        return Objects.equals(this.created, identityProviderApplicationUser.created)
                && Objects.equals(this.externalId, identityProviderApplicationUser.externalId)
                && Objects.equals(this.id, identityProviderApplicationUser.id)
                && Objects.equals(this.lastUpdated, identityProviderApplicationUser.lastUpdated)
                && Objects.equals(this.profile, identityProviderApplicationUser.profile)
                && Objects.equals(this.embedded, identityProviderApplicationUser.embedded)
                && Objects.equals(this.links, identityProviderApplicationUser.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(created, externalId, id, lastUpdated, profile, embedded, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IdentityProviderApplicationUser {\n");
        sb.append("    created: ").append(toIndentedString(created)).append("\n");
        sb.append("    externalId: ").append(toIndentedString(externalId)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    profile: ").append(toIndentedString(profile)).append("\n");
        sb.append("    embedded: ").append(toIndentedString(embedded)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
