package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * The properties in the Identity Provider Properties object vary depending on the IdP type
 */
@ApiModel(description = "The properties in the Identity Provider Properties object vary depending on the IdP type")
@JsonPropertyOrder({ IdentityProviderProperties.JSON_PROPERTY_AAL_VALUE,
        IdentityProviderProperties.JSON_PROPERTY_ADDITIONAL_AMR, IdentityProviderProperties.JSON_PROPERTY_IAL_VALUE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class IdentityProviderProperties implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_AAL_VALUE = "aalValue";
    private JsonNullable<String> aalValue = JsonNullable.<String> undefined();

    /**
     * Gets or Sets additionalAmr
     */
    public enum AdditionalAmrEnum {
        SC(String.valueOf("sc")),

        HWK(String.valueOf("hwk")),

        PIN(String.valueOf("pin")),

        MFA(String.valueOf("mfa")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        AdditionalAmrEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static AdditionalAmrEnum fromValue(String value) {
            for (AdditionalAmrEnum b : AdditionalAmrEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_ADDITIONAL_AMR = "additionalAmr";
    private JsonNullable<List<AdditionalAmrEnum>> additionalAmr = JsonNullable.<List<AdditionalAmrEnum>> undefined();

    public static final String JSON_PROPERTY_IAL_VALUE = "ialValue";
    private JsonNullable<String> ialValue = JsonNullable.<String> undefined();

    public IdentityProviderProperties() {
    }

    public IdentityProviderProperties aalValue(String aalValue) {
        this.aalValue = JsonNullable.<String> of(aalValue);

        return this;
    }

    /**
     * The [authentication assurance level](https://developers.login.gov/oidc/#aal-values) (AAL) value for the Login.gov
     * IdP. See [Add a Login.gov IdP](https://developer.okta.com/docs/guides/add-logingov-idp/). Applies to
     * &#x60;LOGINGOV&#x60; and &#x60;LOGINGOV_SANDBOX&#x60; IdP types.
     *
     * @return aalValue
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The [authentication assurance level](https://developers.login.gov/oidc/#aal-values) (AAL) value for the Login.gov IdP.  See [Add a Login.gov IdP](https://developer.okta.com/docs/guides/add-logingov-idp/). Applies to `LOGINGOV` and `LOGINGOV_SANDBOX` IdP types.")
    @JsonIgnore

    public String getAalValue() {
        return aalValue.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_AAL_VALUE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<String> getAalValue_JsonNullable() {
        return aalValue;
    }

    @JsonProperty(JSON_PROPERTY_AAL_VALUE)
    public void setAalValue_JsonNullable(JsonNullable<String> aalValue) {
        this.aalValue = aalValue;
    }

    public void setAalValue(String aalValue) {
        this.aalValue = JsonNullable.<String> of(aalValue);
    }

    public IdentityProviderProperties additionalAmr(List<AdditionalAmrEnum> additionalAmr) {
        this.additionalAmr = JsonNullable.<List<AdditionalAmrEnum>> of(additionalAmr);

        return this;
    }

    public IdentityProviderProperties addadditionalAmrItem(AdditionalAmrEnum additionalAmrItem) {
        if (this.additionalAmr == null || !this.additionalAmr.isPresent()) {
            this.additionalAmr = JsonNullable.<List<AdditionalAmrEnum>> of(new ArrayList<>());
        }
        try {
            this.additionalAmr.get().add(additionalAmrItem);
        } catch (java.util.NoSuchElementException e) {
            // this can never happen, as we make sure above that the value is present
        }
        return this;
    }

    /**
     * The additional Assurance Methods References (AMR) values for Smart Card IdPs. Applies to &#x60;X509&#x60; IdP
     * type.
     *
     * @return additionalAmr
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The additional Assurance Methods References (AMR) values for Smart Card IdPs. Applies to `X509` IdP type.")
    @JsonIgnore

    public List<AdditionalAmrEnum> getAdditionalAmr() {
        return additionalAmr.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_ADDITIONAL_AMR)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<List<AdditionalAmrEnum>> getAdditionalAmr_JsonNullable() {
        return additionalAmr;
    }

    @JsonProperty(JSON_PROPERTY_ADDITIONAL_AMR)
    public void setAdditionalAmr_JsonNullable(JsonNullable<List<AdditionalAmrEnum>> additionalAmr) {
        this.additionalAmr = additionalAmr;
    }

    public void setAdditionalAmr(List<AdditionalAmrEnum> additionalAmr) {
        this.additionalAmr = JsonNullable.<List<AdditionalAmrEnum>> of(additionalAmr);
    }

    public IdentityProviderProperties ialValue(String ialValue) {
        this.ialValue = JsonNullable.<String> of(ialValue);

        return this;
    }

    /**
     * The [type of identity verification](https://developers.login.gov/oidc/#ial-values) (IAL) value for the Login.gov
     * IdP. See [Add a Login.gov IdP](https://developer.okta.com/docs/guides/add-logingov-idp/). Applies to
     * &#x60;LOGINGOV&#x60; and &#x60;LOGINGOV_SANDBOX&#x60; IdP types.
     *
     * @return ialValue
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The [type of identity verification](https://developers.login.gov/oidc/#ial-values) (IAL) value for the Login.gov IdP.  See [Add a Login.gov IdP](https://developer.okta.com/docs/guides/add-logingov-idp/). Applies to `LOGINGOV` and `LOGINGOV_SANDBOX` IdP types.")
    @JsonIgnore

    public String getIalValue() {
        return ialValue.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_IAL_VALUE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<String> getIalValue_JsonNullable() {
        return ialValue;
    }

    @JsonProperty(JSON_PROPERTY_IAL_VALUE)
    public void setIalValue_JsonNullable(JsonNullable<String> ialValue) {
        this.ialValue = ialValue;
    }

    public void setIalValue(String ialValue) {
        this.ialValue = JsonNullable.<String> of(ialValue);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        IdentityProviderProperties identityProviderProperties = (IdentityProviderProperties) o;
        return equalsNullable(this.aalValue, identityProviderProperties.aalValue)
                && equalsNullable(this.additionalAmr, identityProviderProperties.additionalAmr)
                && equalsNullable(this.ialValue, identityProviderProperties.ialValue);
        // ;
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b
                || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
    }

    @Override
    public int hashCode() {
        return Objects.hash(hashCodeNullable(aalValue), hashCodeNullable(additionalAmr), hashCodeNullable(ialValue));
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[] { a.get() }) : 31;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IdentityProviderProperties {\n");
        sb.append("    aalValue: ").append(toIndentedString(aalValue)).append("\n");
        sb.append("    additionalAmr: ").append(toIndentedString(additionalAmr)).append("\n");
        sb.append("    ialValue: ").append(toIndentedString(ialValue)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
