package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.IdentityProviderType;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * IdpPolicyRuleActionProvider
 */
@JsonPropertyOrder({ IdpPolicyRuleActionProvider.JSON_PROPERTY_ID, IdpPolicyRuleActionProvider.JSON_PROPERTY_NAME,
        IdpPolicyRuleActionProvider.JSON_PROPERTY_TYPE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class IdpPolicyRuleActionProvider implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public static final String JSON_PROPERTY_TYPE = "type";
    private IdentityProviderType type;

    public IdpPolicyRuleActionProvider() {
    }

    public IdpPolicyRuleActionProvider id(String id) {

        this.id = id;
        return this;
    }

    /**
     * IdP types of &#x60;OKTA&#x60;, &#x60;AgentlessDSSO&#x60;, and &#x60;IWA&#x60; don&#39;t require an ID.
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "IdP types of `OKTA`, `AgentlessDSSO`, and `IWA` don't require an ID.")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public IdpPolicyRuleActionProvider name(String name) {

        this.name = name;
        return this;
    }

    /**
     * Provider &#x60;name&#x60; in Okta. Optional. Supported in &#x60;IDENTITY ENGINE&#x60;.
     *
     * @return name
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Provider `name` in Okta. Optional. Supported in `IDENTITY ENGINE`.")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public IdpPolicyRuleActionProvider type(IdentityProviderType type) {

        this.type = type;
        return this;
    }

    /**
     * Get type
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public IdentityProviderType getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setType(IdentityProviderType type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        IdpPolicyRuleActionProvider idpPolicyRuleActionProvider = (IdpPolicyRuleActionProvider) o;
        return Objects.equals(this.id, idpPolicyRuleActionProvider.id)
                && Objects.equals(this.name, idpPolicyRuleActionProvider.name)
                && Objects.equals(this.type, idpPolicyRuleActionProvider.type);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, name, type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IdpPolicyRuleActionProvider {\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
