package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.EnabledStatus;
import com.okta.sdk.resource.model.ImportScheduleObjectFullImport;
import com.okta.sdk.resource.model.ImportScheduleObjectIncrementalImport;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Import schedule configuration
 */
@ApiModel(description = "Import schedule configuration")
@JsonPropertyOrder({ ImportScheduleObject.JSON_PROPERTY_FULL_IMPORT,
        ImportScheduleObject.JSON_PROPERTY_INCREMENTAL_IMPORT, ImportScheduleObject.JSON_PROPERTY_STATUS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class ImportScheduleObject implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_FULL_IMPORT = "fullImport";
    private ImportScheduleObjectFullImport fullImport;

    public static final String JSON_PROPERTY_INCREMENTAL_IMPORT = "incrementalImport";
    private ImportScheduleObjectIncrementalImport incrementalImport;

    public static final String JSON_PROPERTY_STATUS = "status";
    private EnabledStatus status;

    public ImportScheduleObject() {
    }

    public ImportScheduleObject fullImport(ImportScheduleObjectFullImport fullImport) {

        this.fullImport = fullImport;
        return this;
    }

    /**
     * Get fullImport
     *
     * @return fullImport
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_FULL_IMPORT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ImportScheduleObjectFullImport getFullImport() {
        return fullImport;
    }

    @JsonProperty(JSON_PROPERTY_FULL_IMPORT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setFullImport(ImportScheduleObjectFullImport fullImport) {
        this.fullImport = fullImport;
    }

    public ImportScheduleObject incrementalImport(ImportScheduleObjectIncrementalImport incrementalImport) {

        this.incrementalImport = incrementalImport;
        return this;
    }

    /**
     * Get incrementalImport
     *
     * @return incrementalImport
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_INCREMENTAL_IMPORT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ImportScheduleObjectIncrementalImport getIncrementalImport() {
        return incrementalImport;
    }

    @JsonProperty(JSON_PROPERTY_INCREMENTAL_IMPORT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setIncrementalImport(ImportScheduleObjectIncrementalImport incrementalImport) {
        this.incrementalImport = incrementalImport;
    }

    public ImportScheduleObject status(EnabledStatus status) {

        this.status = status;
        return this;
    }

    /**
     * Get status
     *
     * @return status
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public EnabledStatus getStatus() {
        return status;
    }

    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(EnabledStatus status) {
        this.status = status;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ImportScheduleObject importScheduleObject = (ImportScheduleObject) o;
        return Objects.equals(this.fullImport, importScheduleObject.fullImport)
                && Objects.equals(this.incrementalImport, importScheduleObject.incrementalImport)
                && Objects.equals(this.status, importScheduleObject.status);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(fullImport, incrementalImport, status);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ImportScheduleObject {\n");
        sb.append("    fullImport: ").append(toIndentedString(fullImport)).append("\n");
        sb.append("    incrementalImport: ").append(toIndentedString(incrementalImport)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
