package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.OrgCreationAdminCredentials;
import com.okta.sdk.resource.model.OrgCreationAdminProfile;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Profile and credential information for the first super admin user of the child Org. If you plan to configure and
 * manage the Org programmatically, create a system user with a dedicated email address and a strong password. &gt;
 * **Note:** If you don&#39;t provide &#x60;credentials&#x60;, the super admin user is prompted to set up their
 * credentials when they sign in to the Org for the first time.
 */
@ApiModel(description = "Profile and credential information for the first super admin user of the child Org. If you plan to configure and manage the Org programmatically, create a system user with a dedicated email address and a strong password. > **Note:** If you don't provide `credentials`, the super admin user is prompted to set up their credentials when they sign in to the Org for the first time.")
@JsonPropertyOrder({ OrgCreationAdmin.JSON_PROPERTY_CREDENTIALS, OrgCreationAdmin.JSON_PROPERTY_PROFILE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class OrgCreationAdmin implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CREDENTIALS = "credentials";
    private OrgCreationAdminCredentials credentials;

    public static final String JSON_PROPERTY_PROFILE = "profile";
    private OrgCreationAdminProfile profile;

    public OrgCreationAdmin() {
    }

    public OrgCreationAdmin credentials(OrgCreationAdminCredentials credentials) {

        this.credentials = credentials;
        return this;
    }

    /**
     * Get credentials
     *
     * @return credentials
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CREDENTIALS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OrgCreationAdminCredentials getCredentials() {
        return credentials;
    }

    @JsonProperty(JSON_PROPERTY_CREDENTIALS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCredentials(OrgCreationAdminCredentials credentials) {
        this.credentials = credentials;
    }

    public OrgCreationAdmin profile(OrgCreationAdminProfile profile) {

        this.profile = profile;
        return this;
    }

    /**
     * Get profile
     *
     * @return profile
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_PROFILE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public OrgCreationAdminProfile getProfile() {
        return profile;
    }

    @JsonProperty(JSON_PROPERTY_PROFILE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setProfile(OrgCreationAdminProfile profile) {
        this.profile = profile;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OrgCreationAdmin orgCreationAdmin = (OrgCreationAdmin) o;
        return Objects.equals(this.credentials, orgCreationAdmin.credentials)
                && Objects.equals(this.profile, orgCreationAdmin.profile);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(credentials, profile);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrgCreationAdmin {\n");
        sb.append("    credentials: ").append(toIndentedString(credentials)).append("\n");
        sb.append("    profile: ").append(toIndentedString(profile)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
