package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Specifies the profile attributes for the first super admin user. The minimal set of required attributes are
 * &#x60;email&#x60;, &#x60;firstName&#x60;, &#x60;lastName&#x60;, and &#x60;login&#x60;. See
 * [profile](/openapi/okta-management/management/tag/User/#tag/User/operation/getUser!c&#x3D;200&amp;path&#x3D;profile&amp;t&#x3D;response)
 * for additional profile attributes.
 */
@ApiModel(description = "Specifies the profile attributes for the first super admin user. The minimal set of required attributes are `email`, `firstName`, `lastName`, and `login`. See [profile](/openapi/okta-management/management/tag/User/#tag/User/operation/getUser!c=200&path=profile&t=response) for additional profile attributes.")
@JsonPropertyOrder({ OrgCreationAdminProfile.JSON_PROPERTY_FIRST_NAME, OrgCreationAdminProfile.JSON_PROPERTY_LAST_NAME,
        OrgCreationAdminProfile.JSON_PROPERTY_EMAIL, OrgCreationAdminProfile.JSON_PROPERTY_LOGIN })
@JsonTypeName("OrgCreationAdmin_profile")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class OrgCreationAdminProfile implements Serializable {

    private static final long serialVersionUID = 1L;

    public Map<String, Object> additionalProperties = new java.util.LinkedHashMap<>();

    public Map<String, Object> getAdditionalProperties() {
        return additionalProperties;
    }

    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public static final String JSON_PROPERTY_FIRST_NAME = "firstName";
    private String firstName;

    public static final String JSON_PROPERTY_LAST_NAME = "lastName";
    private String lastName;

    public static final String JSON_PROPERTY_EMAIL = "email";
    private String email;

    public static final String JSON_PROPERTY_LOGIN = "login";
    private String login;

    public OrgCreationAdminProfile() {
    }

    public OrgCreationAdminProfile firstName(String firstName) {

        this.firstName = firstName;
        return this;
    }

    /**
     * Given name of the User (&#x60;givenName&#x60;)
     *
     * @return firstName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(required = true, value = "Given name of the User (`givenName`)")
    @JsonProperty(JSON_PROPERTY_FIRST_NAME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getFirstName() {
        return firstName;
    }

    @JsonProperty(JSON_PROPERTY_FIRST_NAME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public OrgCreationAdminProfile lastName(String lastName) {

        this.lastName = lastName;
        return this;
    }

    /**
     * The family name of the User (&#x60;familyName&#x60;)
     *
     * @return lastName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(required = true, value = "The family name of the User (`familyName`)")
    @JsonProperty(JSON_PROPERTY_LAST_NAME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getLastName() {
        return lastName;
    }

    @JsonProperty(JSON_PROPERTY_LAST_NAME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public OrgCreationAdminProfile email(String email) {

        this.email = email;
        return this;
    }

    /**
     * The primary email address of the User. For validation, see [RFC 5322 Section
     * 3.2.3](https://datatracker.ietf.org/doc/html/rfc5322#section-3.2.3).
     *
     * @return email
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "The primary email address of the User. For validation, see [RFC 5322 Section 3.2.3](https://datatracker.ietf.org/doc/html/rfc5322#section-3.2.3).")
    @JsonProperty(JSON_PROPERTY_EMAIL)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getEmail() {
        return email;
    }

    @JsonProperty(JSON_PROPERTY_EMAIL)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setEmail(String email) {
        this.email = email;
    }

    public OrgCreationAdminProfile login(String login) {

        this.login = login;
        return this;
    }

    /**
     * The unique identifier for the User (&#x60;username&#x60;)
     *
     * @return login
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "The unique identifier for the User (`username`)")
    @JsonProperty(JSON_PROPERTY_LOGIN)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getLogin() {
        return login;
    }

    @JsonProperty(JSON_PROPERTY_LOGIN)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setLogin(String login) {
        this.login = login;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OrgCreationAdminProfile orgCreationAdminProfile = (OrgCreationAdminProfile) o;
        return Objects.equals(this.firstName, orgCreationAdminProfile.firstName)
                && Objects.equals(this.lastName, orgCreationAdminProfile.lastName)
                && Objects.equals(this.email, orgCreationAdminProfile.email)
                && Objects.equals(this.login, orgCreationAdminProfile.login);
        // && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(firstName, lastName, email, login, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrgCreationAdminProfile {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    firstName: ").append(toIndentedString(firstName)).append("\n");
        sb.append("    lastName: ").append(toIndentedString(lastName)).append("\n");
        sb.append("    email: ").append(toIndentedString(email)).append("\n");
        sb.append("    login: ").append(toIndentedString(login)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
