package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.AppAndInstancePolicyRuleCondition;
import com.okta.sdk.resource.model.AppInstancePolicyRuleCondition;
import com.okta.sdk.resource.model.BeforeScheduledActionPolicyRuleCondition;
import com.okta.sdk.resource.model.ClientPolicyCondition;
import com.okta.sdk.resource.model.ContextPolicyRuleCondition;
import com.okta.sdk.resource.model.DevicePolicyRuleCondition;
import com.okta.sdk.resource.model.GrantTypePolicyRuleCondition;
import com.okta.sdk.resource.model.GroupPolicyRuleCondition;
import com.okta.sdk.resource.model.IdentityProviderPolicyRuleCondition;
import com.okta.sdk.resource.model.MDMEnrollmentPolicyRuleCondition;
import com.okta.sdk.resource.model.OAuth2ScopesMediationPolicyRuleCondition;
import com.okta.sdk.resource.model.PasswordPolicyAuthenticationProviderCondition;
import com.okta.sdk.resource.model.PlatformPolicyRuleCondition;
import com.okta.sdk.resource.model.PolicyNetworkCondition;
import com.okta.sdk.resource.model.PolicyPeopleCondition;
import com.okta.sdk.resource.model.PolicyRuleAuthContextCondition;
import com.okta.sdk.resource.model.RiskPolicyRuleCondition;
import com.okta.sdk.resource.model.RiskScorePolicyRuleCondition;
import com.okta.sdk.resource.model.UserIdentifierPolicyRuleCondition;
import com.okta.sdk.resource.model.UserPolicyRuleCondition;
import com.okta.sdk.resource.model.UserStatusPolicyRuleCondition;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * PasswordPolicyConditions
 */
@JsonPropertyOrder({ PasswordPolicyConditions.JSON_PROPERTY_APP, PasswordPolicyConditions.JSON_PROPERTY_APPS,
        PasswordPolicyConditions.JSON_PROPERTY_AUTH_CONTEXT, PasswordPolicyConditions.JSON_PROPERTY_AUTH_PROVIDER,
        PasswordPolicyConditions.JSON_PROPERTY_BEFORE_SCHEDULED_ACTION, PasswordPolicyConditions.JSON_PROPERTY_CLIENTS,
        PasswordPolicyConditions.JSON_PROPERTY_CONTEXT, PasswordPolicyConditions.JSON_PROPERTY_DEVICE,
        PasswordPolicyConditions.JSON_PROPERTY_GRANT_TYPES, PasswordPolicyConditions.JSON_PROPERTY_GROUPS,
        PasswordPolicyConditions.JSON_PROPERTY_IDENTITY_PROVIDER, PasswordPolicyConditions.JSON_PROPERTY_MDM_ENROLLMENT,
        PasswordPolicyConditions.JSON_PROPERTY_NETWORK, PasswordPolicyConditions.JSON_PROPERTY_PEOPLE,
        PasswordPolicyConditions.JSON_PROPERTY_PLATFORM, PasswordPolicyConditions.JSON_PROPERTY_RISK,
        PasswordPolicyConditions.JSON_PROPERTY_RISK_SCORE, PasswordPolicyConditions.JSON_PROPERTY_SCOPES,
        PasswordPolicyConditions.JSON_PROPERTY_USER_IDENTIFIER, PasswordPolicyConditions.JSON_PROPERTY_USERS,
        PasswordPolicyConditions.JSON_PROPERTY_USER_STATUS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class PasswordPolicyConditions implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_APP = "app";
    private AppAndInstancePolicyRuleCondition app;

    public static final String JSON_PROPERTY_APPS = "apps";
    private AppInstancePolicyRuleCondition apps;

    public static final String JSON_PROPERTY_AUTH_CONTEXT = "authContext";
    private PolicyRuleAuthContextCondition authContext;

    public static final String JSON_PROPERTY_AUTH_PROVIDER = "authProvider";
    private PasswordPolicyAuthenticationProviderCondition authProvider;

    public static final String JSON_PROPERTY_BEFORE_SCHEDULED_ACTION = "beforeScheduledAction";
    private BeforeScheduledActionPolicyRuleCondition beforeScheduledAction;

    public static final String JSON_PROPERTY_CLIENTS = "clients";
    private ClientPolicyCondition clients;

    public static final String JSON_PROPERTY_CONTEXT = "context";
    private ContextPolicyRuleCondition context;

    public static final String JSON_PROPERTY_DEVICE = "device";
    private DevicePolicyRuleCondition device;

    public static final String JSON_PROPERTY_GRANT_TYPES = "grantTypes";
    private GrantTypePolicyRuleCondition grantTypes;

    public static final String JSON_PROPERTY_GROUPS = "groups";
    private GroupPolicyRuleCondition groups;

    public static final String JSON_PROPERTY_IDENTITY_PROVIDER = "identityProvider";
    private IdentityProviderPolicyRuleCondition identityProvider;

    public static final String JSON_PROPERTY_MDM_ENROLLMENT = "mdmEnrollment";
    private MDMEnrollmentPolicyRuleCondition mdmEnrollment;

    public static final String JSON_PROPERTY_NETWORK = "network";
    private PolicyNetworkCondition network;

    public static final String JSON_PROPERTY_PEOPLE = "people";
    private PolicyPeopleCondition people;

    public static final String JSON_PROPERTY_PLATFORM = "platform";
    private PlatformPolicyRuleCondition platform;

    public static final String JSON_PROPERTY_RISK = "risk";
    private RiskPolicyRuleCondition risk;

    public static final String JSON_PROPERTY_RISK_SCORE = "riskScore";
    private RiskScorePolicyRuleCondition riskScore;

    public static final String JSON_PROPERTY_SCOPES = "scopes";
    private OAuth2ScopesMediationPolicyRuleCondition scopes;

    public static final String JSON_PROPERTY_USER_IDENTIFIER = "userIdentifier";
    private UserIdentifierPolicyRuleCondition userIdentifier;

    public static final String JSON_PROPERTY_USERS = "users";
    private UserPolicyRuleCondition users;

    public static final String JSON_PROPERTY_USER_STATUS = "userStatus";
    private UserStatusPolicyRuleCondition userStatus;

    public PasswordPolicyConditions() {
    }

    public PasswordPolicyConditions app(AppAndInstancePolicyRuleCondition app) {

        this.app = app;
        return this;
    }

    /**
     * Get app
     *
     * @return app
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_APP)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public AppAndInstancePolicyRuleCondition getApp() {
        return app;
    }

    @JsonProperty(JSON_PROPERTY_APP)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setApp(AppAndInstancePolicyRuleCondition app) {
        this.app = app;
    }

    public PasswordPolicyConditions apps(AppInstancePolicyRuleCondition apps) {

        this.apps = apps;
        return this;
    }

    /**
     * Get apps
     *
     * @return apps
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_APPS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public AppInstancePolicyRuleCondition getApps() {
        return apps;
    }

    @JsonProperty(JSON_PROPERTY_APPS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setApps(AppInstancePolicyRuleCondition apps) {
        this.apps = apps;
    }

    public PasswordPolicyConditions authContext(PolicyRuleAuthContextCondition authContext) {

        this.authContext = authContext;
        return this;
    }

    /**
     * Get authContext
     *
     * @return authContext
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_AUTH_CONTEXT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public PolicyRuleAuthContextCondition getAuthContext() {
        return authContext;
    }

    @JsonProperty(JSON_PROPERTY_AUTH_CONTEXT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAuthContext(PolicyRuleAuthContextCondition authContext) {
        this.authContext = authContext;
    }

    public PasswordPolicyConditions authProvider(PasswordPolicyAuthenticationProviderCondition authProvider) {

        this.authProvider = authProvider;
        return this;
    }

    /**
     * Get authProvider
     *
     * @return authProvider
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_AUTH_PROVIDER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public PasswordPolicyAuthenticationProviderCondition getAuthProvider() {
        return authProvider;
    }

    @JsonProperty(JSON_PROPERTY_AUTH_PROVIDER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAuthProvider(PasswordPolicyAuthenticationProviderCondition authProvider) {
        this.authProvider = authProvider;
    }

    public PasswordPolicyConditions beforeScheduledAction(
            BeforeScheduledActionPolicyRuleCondition beforeScheduledAction) {

        this.beforeScheduledAction = beforeScheduledAction;
        return this;
    }

    /**
     * Get beforeScheduledAction
     *
     * @return beforeScheduledAction
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_BEFORE_SCHEDULED_ACTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public BeforeScheduledActionPolicyRuleCondition getBeforeScheduledAction() {
        return beforeScheduledAction;
    }

    @JsonProperty(JSON_PROPERTY_BEFORE_SCHEDULED_ACTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setBeforeScheduledAction(BeforeScheduledActionPolicyRuleCondition beforeScheduledAction) {
        this.beforeScheduledAction = beforeScheduledAction;
    }

    public PasswordPolicyConditions clients(ClientPolicyCondition clients) {

        this.clients = clients;
        return this;
    }

    /**
     * Get clients
     *
     * @return clients
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CLIENTS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ClientPolicyCondition getClients() {
        return clients;
    }

    @JsonProperty(JSON_PROPERTY_CLIENTS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setClients(ClientPolicyCondition clients) {
        this.clients = clients;
    }

    public PasswordPolicyConditions context(ContextPolicyRuleCondition context) {

        this.context = context;
        return this;
    }

    /**
     * Get context
     *
     * @return context
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CONTEXT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ContextPolicyRuleCondition getContext() {
        return context;
    }

    @JsonProperty(JSON_PROPERTY_CONTEXT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setContext(ContextPolicyRuleCondition context) {
        this.context = context;
    }

    public PasswordPolicyConditions device(DevicePolicyRuleCondition device) {

        this.device = device;
        return this;
    }

    /**
     * Get device
     *
     * @return device
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_DEVICE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public DevicePolicyRuleCondition getDevice() {
        return device;
    }

    @JsonProperty(JSON_PROPERTY_DEVICE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDevice(DevicePolicyRuleCondition device) {
        this.device = device;
    }

    public PasswordPolicyConditions grantTypes(GrantTypePolicyRuleCondition grantTypes) {

        this.grantTypes = grantTypes;
        return this;
    }

    /**
     * Get grantTypes
     *
     * @return grantTypes
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_GRANT_TYPES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public GrantTypePolicyRuleCondition getGrantTypes() {
        return grantTypes;
    }

    @JsonProperty(JSON_PROPERTY_GRANT_TYPES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setGrantTypes(GrantTypePolicyRuleCondition grantTypes) {
        this.grantTypes = grantTypes;
    }

    public PasswordPolicyConditions groups(GroupPolicyRuleCondition groups) {

        this.groups = groups;
        return this;
    }

    /**
     * Get groups
     *
     * @return groups
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_GROUPS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public GroupPolicyRuleCondition getGroups() {
        return groups;
    }

    @JsonProperty(JSON_PROPERTY_GROUPS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setGroups(GroupPolicyRuleCondition groups) {
        this.groups = groups;
    }

    public PasswordPolicyConditions identityProvider(IdentityProviderPolicyRuleCondition identityProvider) {

        this.identityProvider = identityProvider;
        return this;
    }

    /**
     * Get identityProvider
     *
     * @return identityProvider
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_IDENTITY_PROVIDER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public IdentityProviderPolicyRuleCondition getIdentityProvider() {
        return identityProvider;
    }

    @JsonProperty(JSON_PROPERTY_IDENTITY_PROVIDER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setIdentityProvider(IdentityProviderPolicyRuleCondition identityProvider) {
        this.identityProvider = identityProvider;
    }

    public PasswordPolicyConditions mdmEnrollment(MDMEnrollmentPolicyRuleCondition mdmEnrollment) {

        this.mdmEnrollment = mdmEnrollment;
        return this;
    }

    /**
     * Get mdmEnrollment
     *
     * @return mdmEnrollment
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_MDM_ENROLLMENT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public MDMEnrollmentPolicyRuleCondition getMdmEnrollment() {
        return mdmEnrollment;
    }

    @JsonProperty(JSON_PROPERTY_MDM_ENROLLMENT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setMdmEnrollment(MDMEnrollmentPolicyRuleCondition mdmEnrollment) {
        this.mdmEnrollment = mdmEnrollment;
    }

    public PasswordPolicyConditions network(PolicyNetworkCondition network) {

        this.network = network;
        return this;
    }

    /**
     * Get network
     *
     * @return network
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_NETWORK)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public PolicyNetworkCondition getNetwork() {
        return network;
    }

    @JsonProperty(JSON_PROPERTY_NETWORK)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setNetwork(PolicyNetworkCondition network) {
        this.network = network;
    }

    public PasswordPolicyConditions people(PolicyPeopleCondition people) {

        this.people = people;
        return this;
    }

    /**
     * Get people
     *
     * @return people
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_PEOPLE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public PolicyPeopleCondition getPeople() {
        return people;
    }

    @JsonProperty(JSON_PROPERTY_PEOPLE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPeople(PolicyPeopleCondition people) {
        this.people = people;
    }

    public PasswordPolicyConditions platform(PlatformPolicyRuleCondition platform) {

        this.platform = platform;
        return this;
    }

    /**
     * Get platform
     *
     * @return platform
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_PLATFORM)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public PlatformPolicyRuleCondition getPlatform() {
        return platform;
    }

    @JsonProperty(JSON_PROPERTY_PLATFORM)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPlatform(PlatformPolicyRuleCondition platform) {
        this.platform = platform;
    }

    public PasswordPolicyConditions risk(RiskPolicyRuleCondition risk) {

        this.risk = risk;
        return this;
    }

    /**
     * Get risk
     *
     * @return risk
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_RISK)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public RiskPolicyRuleCondition getRisk() {
        return risk;
    }

    @JsonProperty(JSON_PROPERTY_RISK)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRisk(RiskPolicyRuleCondition risk) {
        this.risk = risk;
    }

    public PasswordPolicyConditions riskScore(RiskScorePolicyRuleCondition riskScore) {

        this.riskScore = riskScore;
        return this;
    }

    /**
     * Get riskScore
     *
     * @return riskScore
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_RISK_SCORE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public RiskScorePolicyRuleCondition getRiskScore() {
        return riskScore;
    }

    @JsonProperty(JSON_PROPERTY_RISK_SCORE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRiskScore(RiskScorePolicyRuleCondition riskScore) {
        this.riskScore = riskScore;
    }

    public PasswordPolicyConditions scopes(OAuth2ScopesMediationPolicyRuleCondition scopes) {

        this.scopes = scopes;
        return this;
    }

    /**
     * Get scopes
     *
     * @return scopes
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SCOPES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OAuth2ScopesMediationPolicyRuleCondition getScopes() {
        return scopes;
    }

    @JsonProperty(JSON_PROPERTY_SCOPES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setScopes(OAuth2ScopesMediationPolicyRuleCondition scopes) {
        this.scopes = scopes;
    }

    public PasswordPolicyConditions userIdentifier(UserIdentifierPolicyRuleCondition userIdentifier) {

        this.userIdentifier = userIdentifier;
        return this;
    }

    /**
     * Get userIdentifier
     *
     * @return userIdentifier
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_USER_IDENTIFIER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserIdentifierPolicyRuleCondition getUserIdentifier() {
        return userIdentifier;
    }

    @JsonProperty(JSON_PROPERTY_USER_IDENTIFIER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUserIdentifier(UserIdentifierPolicyRuleCondition userIdentifier) {
        this.userIdentifier = userIdentifier;
    }

    public PasswordPolicyConditions users(UserPolicyRuleCondition users) {

        this.users = users;
        return this;
    }

    /**
     * Get users
     *
     * @return users
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_USERS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserPolicyRuleCondition getUsers() {
        return users;
    }

    @JsonProperty(JSON_PROPERTY_USERS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUsers(UserPolicyRuleCondition users) {
        this.users = users;
    }

    public PasswordPolicyConditions userStatus(UserStatusPolicyRuleCondition userStatus) {

        this.userStatus = userStatus;
        return this;
    }

    /**
     * Get userStatus
     *
     * @return userStatus
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_USER_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserStatusPolicyRuleCondition getUserStatus() {
        return userStatus;
    }

    @JsonProperty(JSON_PROPERTY_USER_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUserStatus(UserStatusPolicyRuleCondition userStatus) {
        this.userStatus = userStatus;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PasswordPolicyConditions passwordPolicyConditions = (PasswordPolicyConditions) o;
        return Objects.equals(this.app, passwordPolicyConditions.app)
                && Objects.equals(this.apps, passwordPolicyConditions.apps)
                && Objects.equals(this.authContext, passwordPolicyConditions.authContext)
                && Objects.equals(this.authProvider, passwordPolicyConditions.authProvider)
                && Objects.equals(this.beforeScheduledAction, passwordPolicyConditions.beforeScheduledAction)
                && Objects.equals(this.clients, passwordPolicyConditions.clients)
                && Objects.equals(this.context, passwordPolicyConditions.context)
                && Objects.equals(this.device, passwordPolicyConditions.device)
                && Objects.equals(this.grantTypes, passwordPolicyConditions.grantTypes)
                && Objects.equals(this.groups, passwordPolicyConditions.groups)
                && Objects.equals(this.identityProvider, passwordPolicyConditions.identityProvider)
                && Objects.equals(this.mdmEnrollment, passwordPolicyConditions.mdmEnrollment)
                && Objects.equals(this.network, passwordPolicyConditions.network)
                && Objects.equals(this.people, passwordPolicyConditions.people)
                && Objects.equals(this.platform, passwordPolicyConditions.platform)
                && Objects.equals(this.risk, passwordPolicyConditions.risk)
                && Objects.equals(this.riskScore, passwordPolicyConditions.riskScore)
                && Objects.equals(this.scopes, passwordPolicyConditions.scopes)
                && Objects.equals(this.userIdentifier, passwordPolicyConditions.userIdentifier)
                && Objects.equals(this.users, passwordPolicyConditions.users)
                && Objects.equals(this.userStatus, passwordPolicyConditions.userStatus);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(app, apps, authContext, authProvider, beforeScheduledAction, clients, context, device,
                grantTypes, groups, identityProvider, mdmEnrollment, network, people, platform, risk, riskScore, scopes,
                userIdentifier, users, userStatus);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PasswordPolicyConditions {\n");
        sb.append("    app: ").append(toIndentedString(app)).append("\n");
        sb.append("    apps: ").append(toIndentedString(apps)).append("\n");
        sb.append("    authContext: ").append(toIndentedString(authContext)).append("\n");
        sb.append("    authProvider: ").append(toIndentedString(authProvider)).append("\n");
        sb.append("    beforeScheduledAction: ").append(toIndentedString(beforeScheduledAction)).append("\n");
        sb.append("    clients: ").append(toIndentedString(clients)).append("\n");
        sb.append("    context: ").append(toIndentedString(context)).append("\n");
        sb.append("    device: ").append(toIndentedString(device)).append("\n");
        sb.append("    grantTypes: ").append(toIndentedString(grantTypes)).append("\n");
        sb.append("    groups: ").append(toIndentedString(groups)).append("\n");
        sb.append("    identityProvider: ").append(toIndentedString(identityProvider)).append("\n");
        sb.append("    mdmEnrollment: ").append(toIndentedString(mdmEnrollment)).append("\n");
        sb.append("    network: ").append(toIndentedString(network)).append("\n");
        sb.append("    people: ").append(toIndentedString(people)).append("\n");
        sb.append("    platform: ").append(toIndentedString(platform)).append("\n");
        sb.append("    risk: ").append(toIndentedString(risk)).append("\n");
        sb.append("    riskScore: ").append(toIndentedString(riskScore)).append("\n");
        sb.append("    scopes: ").append(toIndentedString(scopes)).append("\n");
        sb.append("    userIdentifier: ").append(toIndentedString(userIdentifier)).append("\n");
        sb.append("    users: ").append(toIndentedString(users)).append("\n");
        sb.append("    userStatus: ").append(toIndentedString(userStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
