package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Credentials for a Privileged Account
 */
@ApiModel(description = "Credentials for a Privileged Account")
@JsonPropertyOrder({ PrivilegedAccountCredentials.JSON_PROPERTY_PASSWORD,
        PrivilegedAccountCredentials.JSON_PROPERTY_USERNAME })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class PrivilegedAccountCredentials implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_PASSWORD = "password";
    private String password;

    public static final String JSON_PROPERTY_USERNAME = "username";
    private String username;

    public PrivilegedAccountCredentials() {
    }

    public PrivilegedAccountCredentials password(String password) {

        this.password = password;
        return this;
    }

    /**
     * The password associated with the Privileged Account
     *
     * @return password
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The password associated with the Privileged Account")
    @JsonProperty(JSON_PROPERTY_PASSWORD)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getPassword() {
        return password;
    }

    @JsonProperty(JSON_PROPERTY_PASSWORD)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPassword(String password) {
        this.password = password;
    }

    public PrivilegedAccountCredentials username(String username) {

        this.username = username;
        return this;
    }

    /**
     * The username associated with the Privileged Account
     *
     * @return username
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "testuser@example.com", required = true, value = "The username associated with the Privileged Account")
    @JsonProperty(JSON_PROPERTY_USERNAME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getUsername() {
        return username;
    }

    @JsonProperty(JSON_PROPERTY_USERNAME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PrivilegedAccountCredentials privilegedAccountCredentials = (PrivilegedAccountCredentials) o;
        return Objects.equals(this.password, privilegedAccountCredentials.password)
                && Objects.equals(this.username, privilegedAccountCredentials.username);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(password, username);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PrivilegedAccountCredentials {\n");
        sb.append("    password: ").append(toIndentedString(password)).append("\n");
        sb.append("    username: ").append(toIndentedString(username)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
