package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * PrivilegedAccountForUpdate
 */
@JsonPropertyOrder({ PrivilegedAccountForUpdate.JSON_PROPERTY_DESCRIPTION,
        PrivilegedAccountForUpdate.JSON_PROPERTY_EMAIL, PrivilegedAccountForUpdate.JSON_PROPERTY_NAME,
        PrivilegedAccountForUpdate.JSON_PROPERTY_OWNER_GROUP_IDS,
        PrivilegedAccountForUpdate.JSON_PROPERTY_OWNER_USER_IDS, PrivilegedAccountForUpdate.JSON_PROPERTY_USERNAME })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class PrivilegedAccountForUpdate implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;

    public static final String JSON_PROPERTY_EMAIL = "email";
    private String email;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public static final String JSON_PROPERTY_OWNER_GROUP_IDS = "ownerGroupIds";
    private List<String> ownerGroupIds = null;

    public static final String JSON_PROPERTY_OWNER_USER_IDS = "ownerUserIds";
    private List<String> ownerUserIds = null;

    public static final String JSON_PROPERTY_USERNAME = "username";
    private String username;

    public PrivilegedAccountForUpdate() {
    }

    public PrivilegedAccountForUpdate description(String description) {

        this.description = description;
        return this;
    }

    /**
     * The description of the Privileged Account
     *
     * @return description
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "This is for accessing AWS Prod-5", value = "The description of the Privileged Account")
    @JsonProperty(JSON_PROPERTY_DESCRIPTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getDescription() {
        return description;
    }

    @JsonProperty(JSON_PROPERTY_DESCRIPTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public PrivilegedAccountForUpdate email(String email) {

        this.email = email;
        return this;
    }

    /**
     * The email address for the Okta Universal Directory Account
     *
     * @return email
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "foo@bar.com", value = "The email address for the Okta Universal Directory Account")
    @JsonProperty(JSON_PROPERTY_EMAIL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getEmail() {
        return email;
    }

    @JsonProperty(JSON_PROPERTY_EMAIL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setEmail(String email) {
        this.email = email;
    }

    public PrivilegedAccountForUpdate name(String name) {

        this.name = name;
        return this;
    }

    /**
     * The human-readable name for the Privileged Account
     *
     * @return name
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "AWS Prod-5 account", value = "The human-readable name for the Privileged Account")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public PrivilegedAccountForUpdate ownerGroupIds(List<String> ownerGroupIds) {

        this.ownerGroupIds = ownerGroupIds;
        return this;
    }

    public PrivilegedAccountForUpdate addownerGroupIdsItem(String ownerGroupIdsItem) {
        if (this.ownerGroupIds == null) {
            this.ownerGroupIds = new ArrayList<>();
        }
        this.ownerGroupIds.add(ownerGroupIdsItem);
        return this;
    }

    /**
     * A list of IDs of the Okta groups who own the Privileged Account
     *
     * @return ownerGroupIds
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "[\"00g57qp78yZT2XBA40g7\"]", value = "A list of IDs of the Okta groups who own the Privileged Account")
    @JsonProperty(JSON_PROPERTY_OWNER_GROUP_IDS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getOwnerGroupIds() {
        return ownerGroupIds;
    }

    @JsonProperty(JSON_PROPERTY_OWNER_GROUP_IDS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setOwnerGroupIds(List<String> ownerGroupIds) {
        this.ownerGroupIds = ownerGroupIds;
    }

    public PrivilegedAccountForUpdate ownerUserIds(List<String> ownerUserIds) {

        this.ownerUserIds = ownerUserIds;
        return this;
    }

    public PrivilegedAccountForUpdate addownerUserIdsItem(String ownerUserIdsItem) {
        if (this.ownerUserIds == null) {
            this.ownerUserIds = new ArrayList<>();
        }
        this.ownerUserIds.add(ownerUserIdsItem);
        return this;
    }

    /**
     * A list of IDs of the Okta users who own the Privileged Account
     *
     * @return ownerUserIds
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "[\"00u11s48P9zGW8yqm0g5\"]", value = "A list of IDs of the Okta users who own the Privileged Account")
    @JsonProperty(JSON_PROPERTY_OWNER_USER_IDS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getOwnerUserIds() {
        return ownerUserIds;
    }

    @JsonProperty(JSON_PROPERTY_OWNER_USER_IDS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setOwnerUserIds(List<String> ownerUserIds) {
        this.ownerUserIds = ownerUserIds;
    }

    public PrivilegedAccountForUpdate username(String username) {

        this.username = username;
        return this;
    }

    /**
     * The username associated with the Privileged Account
     *
     * @return username
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "testuser@example.com", value = "The username associated with the Privileged Account")
    @JsonProperty(JSON_PROPERTY_USERNAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getUsername() {
        return username;
    }

    @JsonProperty(JSON_PROPERTY_USERNAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PrivilegedAccountForUpdate privilegedAccountForUpdate = (PrivilegedAccountForUpdate) o;
        return Objects.equals(this.description, privilegedAccountForUpdate.description)
                && Objects.equals(this.email, privilegedAccountForUpdate.email)
                && Objects.equals(this.name, privilegedAccountForUpdate.name)
                && Objects.equals(this.ownerGroupIds, privilegedAccountForUpdate.ownerGroupIds)
                && Objects.equals(this.ownerUserIds, privilegedAccountForUpdate.ownerUserIds)
                && Objects.equals(this.username, privilegedAccountForUpdate.username);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(description, email, name, ownerGroupIds, ownerUserIds, username);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PrivilegedAccountForUpdate {\n");
        sb.append("    description: ").append(toIndentedString(description)).append("\n");
        sb.append("    email: ").append(toIndentedString(email)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    ownerGroupIds: ").append(toIndentedString(ownerGroupIds)).append("\n");
        sb.append("    ownerUserIds: ").append(toIndentedString(ownerUserIds)).append("\n");
        sb.append("    username: ").append(toIndentedString(username)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
