package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.ProvisioningDeprovisionedCondition;
import com.okta.sdk.resource.model.ProvisioningSuspendedCondition;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Conditional behaviors for an IdP User during authentication
 */
@ApiModel(description = "Conditional behaviors for an IdP User during authentication")
@JsonPropertyOrder({ ProvisioningConditions.JSON_PROPERTY_DEPROVISIONED,
        ProvisioningConditions.JSON_PROPERTY_SUSPENDED })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class ProvisioningConditions implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_DEPROVISIONED = "deprovisioned";
    private ProvisioningDeprovisionedCondition deprovisioned;

    public static final String JSON_PROPERTY_SUSPENDED = "suspended";
    private ProvisioningSuspendedCondition suspended;

    public ProvisioningConditions() {
    }

    public ProvisioningConditions deprovisioned(ProvisioningDeprovisionedCondition deprovisioned) {

        this.deprovisioned = deprovisioned;
        return this;
    }

    /**
     * Get deprovisioned
     *
     * @return deprovisioned
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_DEPROVISIONED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ProvisioningDeprovisionedCondition getDeprovisioned() {
        return deprovisioned;
    }

    @JsonProperty(JSON_PROPERTY_DEPROVISIONED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDeprovisioned(ProvisioningDeprovisionedCondition deprovisioned) {
        this.deprovisioned = deprovisioned;
    }

    public ProvisioningConditions suspended(ProvisioningSuspendedCondition suspended) {

        this.suspended = suspended;
        return this;
    }

    /**
     * Get suspended
     *
     * @return suspended
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SUSPENDED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ProvisioningSuspendedCondition getSuspended() {
        return suspended;
    }

    @JsonProperty(JSON_PROPERTY_SUSPENDED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSuspended(ProvisioningSuspendedCondition suspended) {
        this.suspended = suspended;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ProvisioningConditions provisioningConditions = (ProvisioningConditions) o;
        return Objects.equals(this.deprovisioned, provisioningConditions.deprovisioned)
                && Objects.equals(this.suspended, provisioningConditions.suspended);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(deprovisioned, suspended);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProvisioningConditions {\n");
        sb.append("    deprovisioned: ").append(toIndentedString(deprovisioned)).append("\n");
        sb.append("    suspended: ").append(toIndentedString(suspended)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
