package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.Office365ProvisioningSettings;
import com.okta.sdk.resource.model.ProvisioningConnectionOauthAuthScheme;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * ProvisioningConnectionOauthRequestProfile
 */
@JsonPropertyOrder({ ProvisioningConnectionOauthRequestProfile.JSON_PROPERTY_AUTH_SCHEME,
        ProvisioningConnectionOauthRequestProfile.JSON_PROPERTY_CLIENT_ID,
        ProvisioningConnectionOauthRequestProfile.JSON_PROPERTY_SETTINGS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class ProvisioningConnectionOauthRequestProfile implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_AUTH_SCHEME = "authScheme";
    private ProvisioningConnectionOauthAuthScheme authScheme;

    public static final String JSON_PROPERTY_CLIENT_ID = "clientId";
    private String clientId;

    public static final String JSON_PROPERTY_SETTINGS = "settings";
    private Office365ProvisioningSettings settings;

    public ProvisioningConnectionOauthRequestProfile() {
    }

    public ProvisioningConnectionOauthRequestProfile authScheme(ProvisioningConnectionOauthAuthScheme authScheme) {

        this.authScheme = authScheme;
        return this;
    }

    /**
     * Get authScheme
     *
     * @return authScheme
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_AUTH_SCHEME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public ProvisioningConnectionOauthAuthScheme getAuthScheme() {
        return authScheme;
    }

    @JsonProperty(JSON_PROPERTY_AUTH_SCHEME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setAuthScheme(ProvisioningConnectionOauthAuthScheme authScheme) {
        this.authScheme = authScheme;
    }

    public ProvisioningConnectionOauthRequestProfile clientId(String clientId) {

        this.clientId = clientId;
        return this;
    }

    /**
     * Only used for the Okta Org2Org (&#x60;okta_org2org&#x60;) app. The unique client identifier for the OAuth 2.0
     * service app from the target org.
     *
     * @return clientId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Only used for the Okta Org2Org (`okta_org2org`) app. The unique client identifier for the OAuth 2.0 service app from the target org.")
    @JsonProperty(JSON_PROPERTY_CLIENT_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getClientId() {
        return clientId;
    }

    @JsonProperty(JSON_PROPERTY_CLIENT_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public ProvisioningConnectionOauthRequestProfile settings(Office365ProvisioningSettings settings) {

        this.settings = settings;
        return this;
    }

    /**
     * Get settings
     *
     * @return settings
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SETTINGS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Office365ProvisioningSettings getSettings() {
        return settings;
    }

    @JsonProperty(JSON_PROPERTY_SETTINGS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSettings(Office365ProvisioningSettings settings) {
        this.settings = settings;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ProvisioningConnectionOauthRequestProfile provisioningConnectionOauthRequestProfile = (ProvisioningConnectionOauthRequestProfile) o;
        return Objects.equals(this.authScheme, provisioningConnectionOauthRequestProfile.authScheme)
                && Objects.equals(this.clientId, provisioningConnectionOauthRequestProfile.clientId)
                && Objects.equals(this.settings, provisioningConnectionOauthRequestProfile.settings);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(authScheme, clientId, settings);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProvisioningConnectionOauthRequestProfile {\n");
        sb.append("    authScheme: ").append(toIndentedString(authScheme)).append("\n");
        sb.append("    clientId: ").append(toIndentedString(clientId)).append("\n");
        sb.append("    settings: ").append(toIndentedString(settings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
