package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Provisioning action for the IdP User&#39;s Group memberships | Enum | Description | Existing OKTA_GROUP Memberships |
 * Existing APP_GROUP Memberships | Existing BUILT_IN Memberships | | -------- |
 * -----------------------------------------------------------------------------------------------------------------------------------------------------------------
 * | ----------------------------------------------------------------------------------------------------- |
 * ------------------------------ | ----------------------------- | | &#x60;APPEND&#x60; | Adds a User to any Group
 * defined by the IdP as a value of the &#x60;sourceAttributeName&#x60; array that matches the name of the allow listed
 * Group defined in the &#x60;filter&#x60; | Unchanged | Unchanged | Unchanged | | &#x60;ASSIGN&#x60; | Assigns a User
 * to Groups defined in the &#x60;assignments&#x60; array | Unchanged | Unchanged | Unchanged | | &#x60;NONE&#x60; |
 * Skips processing of Group memberships | Unchanged | Unchanged | Unchanged | | &#x60;SYNC&#x60; | Group memberships
 * are sourced by the IdP as a value of the &#x60;sourceAttributeName&#x60; array that matches the name of the Group
 * defined in the &#x60;filter&#x60; | Removed if not defined by the IdP in &#x60;sourceAttributeName&#x60; and matching
 * name of the Group in &#x60;filter&#x60; | Unchanged | Unchanged | &gt; **Note:** Group provisioning action is
 * processed independently from profile sourcing. You can sync Group memberships through SAML with profile sourcing
 * disabled.
 */
public enum ProvisioningGroupsAction {

    APPEND("APPEND"),

    ASSIGN("ASSIGN"),

    NONE("NONE"),

    SYNC("SYNC"),

    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    ProvisioningGroupsAction(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static ProvisioningGroupsAction fromValue(String value) {
        for (ProvisioningGroupsAction b : ProvisioningGroupsAction.values()) {
            if (b.value.equals(value)) {
                return b;
            }
        }
        return UNKNOWN_DEFAULT_OPEN_API;
    }

    /**
     * Convert the instance into URL query string.
     *
     * @param prefix
     *            prefix of the query string
     *
     * @return URL query string
     */
    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }

        return String.format("%s=%s", prefix, this.toString().toString());
    }
}
