package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * ResourceSelectorPatchRequestSchema
 */
@JsonPropertyOrder({ ResourceSelectorPatchRequestSchema.JSON_PROPERTY_DESCRIPTION,
        ResourceSelectorPatchRequestSchema.JSON_PROPERTY_FILTER,
        ResourceSelectorPatchRequestSchema.JSON_PROPERTY_NAME })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class ResourceSelectorPatchRequestSchema implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;

    public static final String JSON_PROPERTY_FILTER = "filter";
    private String filter;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public ResourceSelectorPatchRequestSchema() {
    }

    public ResourceSelectorPatchRequestSchema description(String description) {

        this.description = description;
        return this;
    }

    /**
     * Description of the Resource Selector
     *
     * @return description
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Description of the Resource Selector")
    @JsonProperty(JSON_PROPERTY_DESCRIPTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getDescription() {
        return description;
    }

    @JsonProperty(JSON_PROPERTY_DESCRIPTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public ResourceSelectorPatchRequestSchema filter(String filter) {

        this.filter = filter;
        return this;
    }

    /**
     * SCIM filter of the Resource Selector
     *
     * @return filter
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "SCIM filter of the Resource Selector")
    @JsonProperty(JSON_PROPERTY_FILTER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getFilter() {
        return filter;
    }

    @JsonProperty(JSON_PROPERTY_FILTER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setFilter(String filter) {
        this.filter = filter;
    }

    public ResourceSelectorPatchRequestSchema name(String name) {

        this.name = name;
        return this;
    }

    /**
     * Name of the Resource Selector
     *
     * @return name
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Name of the Resource Selector")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ResourceSelectorPatchRequestSchema resourceSelectorPatchRequestSchema = (ResourceSelectorPatchRequestSchema) o;
        return Objects.equals(this.description, resourceSelectorPatchRequestSchema.description)
                && Objects.equals(this.filter, resourceSelectorPatchRequestSchema.filter)
                && Objects.equals(this.name, resourceSelectorPatchRequestSchema.name);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(description, filter, name);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourceSelectorPatchRequestSchema {\n");
        sb.append("    description: ").append(toIndentedString(description)).append("\n");
        sb.append("    filter: ").append(toIndentedString(filter)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
