package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.HrefObject;
import com.okta.sdk.resource.model.HrefObjectSelfLink;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * ResourceSetBindingResponseLinks
 */
@JsonPropertyOrder({ ResourceSetBindingResponseLinks.JSON_PROPERTY_SELF,
        ResourceSetBindingResponseLinks.JSON_PROPERTY_BINDINGS,
        ResourceSetBindingResponseLinks.JSON_PROPERTY_RESOURCE_SET })
@JsonTypeName("ResourceSetBindingResponse__links")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class ResourceSetBindingResponseLinks implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_SELF = "self";
    private HrefObjectSelfLink self;

    public static final String JSON_PROPERTY_BINDINGS = "bindings";
    private HrefObject bindings;

    public static final String JSON_PROPERTY_RESOURCE_SET = "resource-set";
    private HrefObject resourceSet;

    public ResourceSetBindingResponseLinks() {
    }

    public ResourceSetBindingResponseLinks self(HrefObjectSelfLink self) {

        this.self = self;
        return this;
    }

    /**
     * Get self
     *
     * @return self
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SELF)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public HrefObjectSelfLink getSelf() {
        return self;
    }

    @JsonProperty(JSON_PROPERTY_SELF)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSelf(HrefObjectSelfLink self) {
        this.self = self;
    }

    public ResourceSetBindingResponseLinks bindings(HrefObject bindings) {

        this.bindings = bindings;
        return this;
    }

    /**
     * Get bindings
     *
     * @return bindings
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_BINDINGS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public HrefObject getBindings() {
        return bindings;
    }

    @JsonProperty(JSON_PROPERTY_BINDINGS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setBindings(HrefObject bindings) {
        this.bindings = bindings;
    }

    public ResourceSetBindingResponseLinks resourceSet(HrefObject resourceSet) {

        this.resourceSet = resourceSet;
        return this;
    }

    /**
     * Get resourceSet
     *
     * @return resourceSet
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_RESOURCE_SET)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public HrefObject getResourceSet() {
        return resourceSet;
    }

    @JsonProperty(JSON_PROPERTY_RESOURCE_SET)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setResourceSet(HrefObject resourceSet) {
        this.resourceSet = resourceSet;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ResourceSetBindingResponseLinks resourceSetBindingResponseLinks = (ResourceSetBindingResponseLinks) o;
        return Objects.equals(this.self, resourceSetBindingResponseLinks.self)
                && Objects.equals(this.bindings, resourceSetBindingResponseLinks.bindings)
                && Objects.equals(this.resourceSet, resourceSetBindingResponseLinks.resourceSet);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(self, bindings, resourceSet);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourceSetBindingResponseLinks {\n");
        sb.append("    self: ").append(toIndentedString(self)).append("\n");
        sb.append("    bindings: ").append(toIndentedString(bindings)).append("\n");
        sb.append("    resourceSet: ").append(toIndentedString(resourceSet)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
