package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.RoleGovernanceResource;
import com.okta.sdk.resource.model.RoleGovernanceResourcesLinks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * The resources of a grant
 */
@ApiModel(description = "The resources of a grant")
@JsonPropertyOrder({ RoleGovernanceResources.JSON_PROPERTY_RESOURCES, RoleGovernanceResources.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class RoleGovernanceResources implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_RESOURCES = "resources";
    private List<RoleGovernanceResource> resources = null;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private RoleGovernanceResourcesLinks links;

    public RoleGovernanceResources() {
    }

    public RoleGovernanceResources resources(List<RoleGovernanceResource> resources) {

        this.resources = resources;
        return this;
    }

    public RoleGovernanceResources addresourcesItem(RoleGovernanceResource resourcesItem) {
        if (this.resources == null) {
            this.resources = new ArrayList<>();
        }
        this.resources.add(resourcesItem);
        return this;
    }

    /**
     * Get resources
     *
     * @return resources
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_RESOURCES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<RoleGovernanceResource> getResources() {
        return resources;
    }

    @JsonProperty(JSON_PROPERTY_RESOURCES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setResources(List<RoleGovernanceResource> resources) {
        this.resources = resources;
    }

    public RoleGovernanceResources links(RoleGovernanceResourcesLinks links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public RoleGovernanceResourcesLinks getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(RoleGovernanceResourcesLinks links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RoleGovernanceResources roleGovernanceResources = (RoleGovernanceResources) o;
        return Objects.equals(this.resources, roleGovernanceResources.resources)
                && Objects.equals(this.links, roleGovernanceResources.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(resources, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RoleGovernanceResources {\n");
        sb.append("    resources: ").append(toIndentedString(resources)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
