package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.SAMLPayLoadDataAssertionAuthenticationAuthnContext;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Provides a JSON representation of the &#x60;&lt;saml:AuthnStatement&gt;&#x60; element of the SAML assertion
 */
@ApiModel(description = "Provides a JSON representation of the `<saml:AuthnStatement>` element of the SAML assertion")
@JsonPropertyOrder({ SAMLPayLoadDataAssertionAuthentication.JSON_PROPERTY_SESSION_INDEX,
        SAMLPayLoadDataAssertionAuthentication.JSON_PROPERTY_AUTHN_CONTEXT })
@JsonTypeName("SAMLPayLoad_data_assertion_authentication")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class SAMLPayLoadDataAssertionAuthentication implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_SESSION_INDEX = "sessionIndex";
    private String sessionIndex;

    public static final String JSON_PROPERTY_AUTHN_CONTEXT = "authnContext";
    private SAMLPayLoadDataAssertionAuthenticationAuthnContext authnContext;

    public SAMLPayLoadDataAssertionAuthentication() {
    }

    public SAMLPayLoadDataAssertionAuthentication sessionIndex(String sessionIndex) {

        this.sessionIndex = sessionIndex;
        return this;
    }

    /**
     * The unique identifier describing the assertion statement
     *
     * @return sessionIndex
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "id1553800523546.312669168", value = "The unique identifier describing the assertion statement")
    @JsonProperty(JSON_PROPERTY_SESSION_INDEX)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getSessionIndex() {
        return sessionIndex;
    }

    @JsonProperty(JSON_PROPERTY_SESSION_INDEX)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSessionIndex(String sessionIndex) {
        this.sessionIndex = sessionIndex;
    }

    public SAMLPayLoadDataAssertionAuthentication authnContext(
            SAMLPayLoadDataAssertionAuthenticationAuthnContext authnContext) {

        this.authnContext = authnContext;
        return this;
    }

    /**
     * Get authnContext
     *
     * @return authnContext
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_AUTHN_CONTEXT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SAMLPayLoadDataAssertionAuthenticationAuthnContext getAuthnContext() {
        return authnContext;
    }

    @JsonProperty(JSON_PROPERTY_AUTHN_CONTEXT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAuthnContext(SAMLPayLoadDataAssertionAuthenticationAuthnContext authnContext) {
        this.authnContext = authnContext;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SAMLPayLoadDataAssertionAuthentication saMLPayLoadDataAssertionAuthentication = (SAMLPayLoadDataAssertionAuthentication) o;
        return Objects.equals(this.sessionIndex, saMLPayLoadDataAssertionAuthentication.sessionIndex)
                && Objects.equals(this.authnContext, saMLPayLoadDataAssertionAuthentication.authnContext);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(sessionIndex, authnContext);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SAMLPayLoadDataAssertionAuthentication {\n");
        sb.append("    sessionIndex: ").append(toIndentedString(sessionIndex)).append("\n");
        sb.append("    authnContext: ").append(toIndentedString(authnContext)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
