package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Details of the authentication methods used for the SAML assertion
 */
@ApiModel(description = "Details of the authentication methods used for the SAML assertion")
@JsonPropertyOrder({ SAMLPayLoadDataAssertionAuthenticationAuthnContext.JSON_PROPERTY_AUTHN_CONTEXT_CLASS_REF })
@JsonTypeName("SAMLPayLoad_data_assertion_authentication_authnContext")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class SAMLPayLoadDataAssertionAuthenticationAuthnContext implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_AUTHN_CONTEXT_CLASS_REF = "authnContextClassRef";
    private String authnContextClassRef;

    public SAMLPayLoadDataAssertionAuthenticationAuthnContext() {
    }

    public SAMLPayLoadDataAssertionAuthenticationAuthnContext authnContextClassRef(String authnContextClassRef) {

        this.authnContextClassRef = authnContextClassRef;
        return this;
    }

    /**
     * Describes the identity provider&#39;s supported authentication context classes
     *
     * @return authnContextClassRef
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport", value = "Describes the identity provider's supported authentication context classes")
    @JsonProperty(JSON_PROPERTY_AUTHN_CONTEXT_CLASS_REF)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getAuthnContextClassRef() {
        return authnContextClassRef;
    }

    @JsonProperty(JSON_PROPERTY_AUTHN_CONTEXT_CLASS_REF)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAuthnContextClassRef(String authnContextClassRef) {
        this.authnContextClassRef = authnContextClassRef;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SAMLPayLoadDataAssertionAuthenticationAuthnContext saMLPayLoadDataAssertionAuthenticationAuthnContext = (SAMLPayLoadDataAssertionAuthenticationAuthnContext) o;
        return Objects.equals(this.authnContextClassRef,
                saMLPayLoadDataAssertionAuthenticationAuthnContext.authnContextClassRef);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(authnContextClassRef);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SAMLPayLoadDataAssertionAuthenticationAuthnContext {\n");
        sb.append("    authnContextClassRef: ").append(toIndentedString(authnContextClassRef)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
