package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Provides a JSON representation of the &#x60;&lt;saml:Conditions&gt;&#x60; element of the SAML assertion
 */
@ApiModel(description = "Provides a JSON representation of the `<saml:Conditions>` element of the SAML assertion")
@JsonPropertyOrder({ SAMLPayLoadDataAssertionConditions.JSON_PROPERTY_AUDIENCE_RESTRICTION })
@JsonTypeName("SAMLPayLoad_data_assertion_conditions")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class SAMLPayLoadDataAssertionConditions implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_AUDIENCE_RESTRICTION = "audienceRestriction";
    private List<String> audienceRestriction = null;

    public SAMLPayLoadDataAssertionConditions() {
    }

    public SAMLPayLoadDataAssertionConditions audienceRestriction(List<String> audienceRestriction) {

        this.audienceRestriction = audienceRestriction;
        return this;
    }

    public SAMLPayLoadDataAssertionConditions addaudienceRestrictionItem(String audienceRestrictionItem) {
        if (this.audienceRestriction == null) {
            this.audienceRestriction = new ArrayList<>();
        }
        this.audienceRestriction.add(audienceRestrictionItem);
        return this;
    }

    /**
     * Describes which service providers the assertion is valid for
     *
     * @return audienceRestriction
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Describes which service providers the assertion is valid for")
    @JsonProperty(JSON_PROPERTY_AUDIENCE_RESTRICTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getAudienceRestriction() {
        return audienceRestriction;
    }

    @JsonProperty(JSON_PROPERTY_AUDIENCE_RESTRICTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAudienceRestriction(List<String> audienceRestriction) {
        this.audienceRestriction = audienceRestriction;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SAMLPayLoadDataAssertionConditions saMLPayLoadDataAssertionConditions = (SAMLPayLoadDataAssertionConditions) o;
        return Objects.equals(this.audienceRestriction, saMLPayLoadDataAssertionConditions.audienceRestriction);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(audienceRestriction);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SAMLPayLoadDataAssertionConditions {\n");
        sb.append("    audienceRestriction: ").append(toIndentedString(audienceRestriction)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
